<?php
namespace PixelYourSite;

class EnrichOrder {
    private static $_instance;

    public static function instance() {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        add_action( 'init', array( $this, 'init' ), 10 );
    }

    function init() {
        //woo
        if(PYS()->getOption("woo_enabled_save_data_to_orders")) {
            add_filter( 'woocommerce_checkout_fields' , array($this,'woo_add_checkout_fields') );
            add_action( 'woocommerce_checkout_update_order_meta',array($this,'woo_save_checkout_fields'),10, 2);
            add_action( 'add_meta_boxes', array($this,'woo_add_order_meta_boxes') );
        }

        // edd
        if(PYS()->getOption("edd_enabled_save_data_to_orders")) {
            add_action('edd_view_order_details_main_after', array($this, 'add_edd_order_details'));
            add_action('edd_purchase_form_before_cc_form', array($this, 'add_edd_checkout_fields'));
            add_filter('edd_payment_meta', array($this, 'edd_save_checkout_fields'));
        }
    }

    function woo_add_checkout_fields( $fields ) {
        $fields['order']['pys_landing']['type'] = 'hidden';
        $fields['order']['pys_source']['type'] = 'hidden';
        $fields['order']['pys_utm']['type'] = 'hidden';
        $fields['order']['pys_browser_time']['type'] = 'hidden';
        return $fields;
    }

    function woo_save_checkout_fields($order_id, $data) {
        $order = wc_get_order($order_id);
        $pysData = [];
        if(get_current_user_id()) {
            $totals = getWooCustomerTotals();
        } else {
            $totals = getWooCustomerTotalsByEmail($order->get_billing_email());
            if($totals['orders_count'] == 0) {
                $totals = array(
                    'orders_count' => 'Guest order',
                    'avg_order_value' => 'Guest order',
                    'ltv' => 'Guest order',
                );
            }
        }

        $pysData['pys_landing'] = isset($data['pys_landing']) ? sanitize_text_field($data['pys_landing']) : "";
        $pysData['pys_source'] = isset($data['pys_source']) ? sanitize_text_field($data['pys_source']) : "";
        $pysData['pys_utm'] = isset($data['pys_utm']) ? sanitize_text_field($data['pys_utm']) : "";
        $pysData['pys_browser_time'] = isset($data['pys_browser_time']) ? sanitize_text_field($data['pys_browser_time']) : "";

        $pysData = array_merge($pysData,$totals);

        update_post_meta($order_id,"pys_enrich_data",$pysData);
    }

    function woo_add_order_meta_boxes () {
        add_meta_box( 'pys_enrich_fields_woo', __('PixelYourSite Pro','woocommerce'),
            array($this,"woo_render_order_fields"), 'shop_order');
    }

    function woo_render_order_fields() {
        include 'views/html-order-meta-box.php';
    }


    function add_edd_checkout_fields() {
        $fields = ['pys_landing','pys_source','pys_utm','pys_browser_time'];
        foreach ($fields as $field) : ?>
            <div id="<?=$field?>_field">
                <input type="hidden" name="<?=$field?>" />
            </div>
        <?php endforeach;
    }

    function edd_save_checkout_fields( $payment_meta ) {

        if ( 0 !== did_action('edd_pre_process_purchase') ) {
            $pysData = [];

            if(get_current_user_id()) {
                $totals = getEddCustomerTotals();
            } else {
                $totals = getEddCustomerTotalsByEmail($payment_meta['email']);
                if($totals['orders_count'] == 0) {
                    $totals = array(
                        'orders_count' => 'Guest order',
                        'avg_order_value' => 'Guest order',
                        'ltv' => 'Guest order',
                    );
                }
            }


            $pysData['pys_landing'] = isset($_POST['pys_landing']) ? sanitize_text_field($_POST['pys_landing']) : "";
            $pysData['pys_source'] = isset($_POST['pys_source']) ? sanitize_text_field($_POST['pys_source']) : "";
            $pysData['pys_utm'] = isset($_POST['pys_utm']) ? sanitize_text_field($_POST['pys_utm']) : "";
            $pysData['pys_browser_time'] = isset($_POST['pys_browser_time']) ? sanitize_text_field($_POST['pys_browser_time']) : "";

            $pysData = array_merge($pysData,$totals);
            $payment_meta['pys_enrich_data'] = $pysData;
        }

        return $payment_meta;
    }


    function add_edd_order_details($payment_id) {
        include 'views/html-edd-order-box.php';
    }
}

/**
 * @return EnrichOrder
 */
function EnrichOrder() {
    return EnrichOrder::instance();
}

EnrichOrder();

