<?php 

/*
* Template name: Store Locator
*/

get_header(); 

if (isset($_GET['searchinput']) && !empty($_GET['searchinput'])) {
    $searchval = $_GET['searchinput'];
    /*
    $q1 = array();
    $q2 = array();
    $myarray = array();
    // $q4 = array();

    $args = array(
        'post_type' => 'selskaper',
        'post_status' => 'publish',
        's' => $searchval,
        'posts_per_page' => -1,
        'fields' => 'ids',
    );

    if($searchval){
        $q1 = get_posts($args);

        //post meta for address details
        $q2 = get_posts(array(
            'post_type' => 'selskaper',
            'post_status' => 'publish',
            'fields' => 'ids',
            'meta_query' => array(
                'relation' => 'OR',
                array(
                    'key' => 'adresse',
                    'value' => $searchval,
                    'compare' => 'LIKE'
                ),
            )
        ));
    }

    $merged = array_merge($q1, $q2);

    // print_r($merged);

    $post_ids = array();
    foreach ($merged as $item) {
        $post_ids[] = $item;
    }

    $unique = array_unique($merged);

    if (!$unique) {
        $unique = array('0');
    }

    $args = array(
        'posts_per_page' => -1,
        'post_type' => 'selskaper',
        'post__in' => $unique,
        'post_status' => 'publish'
    );
    */
} else {
    $searchval = '';
}

$args = array(
    'post_type' => 'selskaper',
    'posts_per_page' => -1,
    'post_status' => 'publish'
);

$city_term = '';
if(isset($_GET['regions'])){
    $city_term = stripslashes($_GET['regions']);
    // print_r($city_term);
    if(!empty($city_term)){
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'region_selskaper',
                'field' => 'slug',
                'terms' => [$city_term] 
            )
        );
    }
}

// var_dump($args);
$the_query = new WP_Query($args);

//count number of posts
$count = $wp_query->found_posts;
$total_posts = $count;
$i =0;
//loop through posts
while ($the_query->have_posts()) {
    $the_query->the_post();

    //print_r($the_query);exit();
    $postid = get_the_ID();
    $place = get_post_meta($postid, 'adresse', TRUE);
    $title = get_the_title();
    $lat = get_post_meta($postid, 'latitude', TRUE);
    $lng = get_post_meta($postid, 'longitude', TRUE);
    
    $content = "<div class='marker_info'><h4 class='marker_info__title'>".$title."</h4><p class='marker_info__addr'>".$place."</p><a class='link' href='".get_the_permalink($postid)."'>".__('Kontakt Oss','sefbo')."</a></div>";

    $myarray[] = array('address' => $place, "content" => $content, 'id' => $postid, 'lat' => $lat, 'long' => $lng);

    $i++;

    // use reset postdata to restore orginal query
    wp_reset_postdata();
}

//json array of details	
$new1 = json_encode($myarray);

//echo $new1;
?>

<script>
    var fulldata = <?php echo $new1; ?>;
    var searchval = '<?php echo $searchval; ?>';

    var marker;
    var map;
    var infowindow = new google.maps.InfoWindow();
    var geocoder = new google.maps.Geocoder();

    function initialize(e, fullcontent) {
        if(typeof fullcontent === 'undefined'){
            fullcontent = fulldata;
        }
        var bounds = new google.maps.LatLngBounds();
        var markers = [];
        var temp_m = {};
        if (window.location.href.indexOf("id") > -1){
            var mapProp = {
                center: new google.maps.LatLng(60.472024, 8.468946),
                //mapTypeId: google.maps.MapTypeId.HYBRID,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                disableDefaultUI : true,
                //scrollwheel: true,
            };
        } else {
            var mapProp = {
                center: new google.maps.LatLng(60.472024, 8.468946),
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                disableDefaultUI : true,
                //scrollwheel: true,
            };
        }

        map = new google.maps.Map(document.getElementById("mapArea"), mapProp);

        // google.maps.event.addListener(map, 'click', function(event) {
        //   map.setOptions({
        //     scrollwheel: true,
        //   });
        // });//23-12

        //console.log(fulldata[0]);
        // console.log(fullcontent);

        google.maps.event.addListener(map, 'mouseout', function (event) {
             this.setOptions({scrollwheel: false});
        });

        google.maps.event.addListener(map, 'mousedown', function (event) {
             this.setOptions({scrollwheel: true});
        });

        var imagePath = "<?php echo get_stylesheet_directory_uri().'/images/cluster-map-marker.png';?>";

        var clusterStyles = [
          {
            textColor: 'white',
            textSize:25,
            url: imagePath,
            height: 48,
            width: 48
          },
         {
            textColor: 'white',
            textSize:25,
            url: imagePath,
            height: 48,
            width: 48
          },
         {
            textColor: 'white',
            textSize:25,
            url: imagePath,
            height: 48,
            width: 48
          }
        ];

        var set_center = false;
        
        const markerCluster = new markerClusterer.MarkerClusterer({ map, markers }); 

        // const markerCluster = new MarkerClusterer( map, markers, {
        //     gridSize: 48,
        //     cssClass: 'cluster',
        //     styles: clusterStyles,
        //     minimumClusterSize: 2,
        // });
        jQuery.each(fullcontent, function (key, data) {
            var address = data.address;
            //console.log(address);
            var custom_marker = '<?php echo get_stylesheet_directory_uri().'/images/custom-map-marker.png';?>';
            if (data.lat == '' || data.lat == null) {
                if(address){
                    geocoder.geocode({'address': address}, function (results, status) {
                        // console.log(address, results[0].geometry.location.lat(), results[0].geometry.location.lng());
                        // map.setCenter(results[0].geometry.location);
                        marker = new google.maps.Marker({
                            map: map,
                            icon: custom_marker,
                            position: results[0].geometry.location,
                            optimized: false
                        });

                        if(!set_center){
                            map.setCenter(results[0].geometry.location);
                            set_center = true;
                        }
                        
                        bounds.extend(marker.position);
                        markerCluster.addMarker(marker);
                        //markers.push(marker);

                        if(jQuery('.map-image#store-id-'+data.id).length){
                            // var t = "<img src='https://maps.googleapis.com/maps/api/staticmap?center="+elem.latitude+","+elem.longitude+"&zoom=15&size=270x270&maptype=roadmap&markers="+elem.latitude+","+elem.longitude+"&key=AIzaSyCnaCYVjfX6hJ_7Y5n1C7wGsp5HEJy6goI' width='100%' height='270' frameborder='0' style='border:0'>";
                            var card_map = new google.maps.Map(document.getElementById("store-id-"+data.id), {
                                center: {lat: -34.397, lng: 150.644},
                                zoom: 11,
                                disableDefaultUI: true,
                                zoomControl: false,
                                mapTypeControl: false,
                                scaleControl: false,
                                streetViewControl: false,
                                rotateControl: false,
                                fullscreenControl: false,
                                panControl: false,
                                scrollwheel: false,
                            });
                            card_map.setCenter(results[0].geometry.location);
                            var card_marker = new google.maps.Marker({
                                map: card_map,
                                position: results[0].geometry.location
                            });
                        }

                        var details = data.content;
                        bindInfoWindow(marker, map, infowindow, details);
                    });
                }
            }
            else {
                var latLng = new google.maps.LatLng(data.lat, data.long);
                // console.log(address, data.lat, data.long);

                // map.setCenter(latLng);
                marker = new google.maps.Marker({
                    map: map,
                    icon: custom_marker,
                    position: latLng
                });

                if(!set_center){
                    map.setCenter(latLng);
                    set_center = true;
                }
                        
                bounds.extend(marker.position);
                markerCluster.addMarker(marker);
                //markers.push(marker);

                if(jQuery('.map-image#store-id-'+data.id).length){
                    // var t = "<img src='https://maps.googleapis.com/maps/api/staticmap?center="+elem.latitude+","+elem.longitude+"&zoom=15&size=270x270&maptype=roadmap&markers="+elem.latitude+","+elem.longitude+"&key=AIzaSyCnaCYVjfX6hJ_7Y5n1C7wGsp5HEJy6goI' width='100%' height='270' frameborder='0' style='border:0'>";
                    var card_map = new google.maps.Map(document.getElementById("store-id-"+data.id), {
                        center: {lat: -34.397, lng: 150.644},
                        zoom: 11,
                        disableDefaultUI: true,
                        zoomControl: false,
                        mapTypeControl: false,
                        scaleControl: false,
                        streetViewControl: false,
                        rotateControl: false,
                        fullscreenControl: false,
                        panControl: false,
                        scrollwheel: false,
                    });
                    card_map.setCenter(latLng);
                    var card_marker = new google.maps.Marker({
                        map: card_map,
                        position: latLng
                    });
                }

                var details = data.content;
                bindInfoWindow(marker, map, infowindow, details);
            }
        });
         
        map.fitBounds(bounds);
    }


    function bindInfoWindow(marker, map, infowindow, strDescription) {

        google.maps.event.addListener(marker, 'click', function () {
            infowindow.setContent(strDescription);
            infowindow.open(map, marker);
            // jQuery('.gm-style-iw').parent().addClass('marker_border');
        });
        // google.maps.event.addListener(marker, 'mouseout', function () {
        //     infowindow.close();
        // });
        // google.maps.event.addListener(marker, 'click', function () {
        //     infowindow.close();
        // });
        google.maps.event.addListener(map, 'click', function () {
            infowindow.close();
        });
    }

    if(!searchval)
        google.maps.event.addDomListener(window, 'load', initialize);
    else
        google.maps.event.addDomListener(window, 'load', function(e){
            jQuery("#searchinput").trigger('keyup');
        });

</script>

<?php while ( have_posts() ) : the_post(); ?> 
    
    <section class="store-locator">
        <!-- Map banner -->
        <?php get_template_part('template-parts/content', 'map-banner'); ?>

        <div class="container-fluid content-width">

            <div class="row">
                <div class="col-lg-7 support-content">    

                    <div class="store-locator__wrapper">
                        
                        <h2 class="store-locator__heading">
                            <?php _e('Finn ditt nærmeste selskap:','sefbo');?>
                        </h2>
                        <!-- Attributes -->
                        <div class="d-flex store-locator__options">
                            <!-- Region -->
                            <?php 
                                $regions = get_terms( array(
                                    'taxonomy' => 'region_selskaper',
                                    'hide_empty' => true,
                                ) );
                                
                                if($regions){ ?>
                                    <div class="region">
                                        <select name="filter-regions" id="filter-regions" class="custom-select" required>
                                        <option value=""  <?php echo $city_term == '' ? 'selected' : ''; ?>><?php echo _e('Velg fylke','sefbo'); ?></option>
                                            <?php foreach ($regions as $city){ ?>
                                                <option value="<?php echo $city->slug; ?>" <?php echo ($city_term != '' && $city_term == $city->slug) ? 'selected' : ''; ?>><?php echo $city->name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php }
                            ?>
                            <!-- Search store -->
                            <div class="store-search-wrap">
                                <div class="search-wrap">
                                    <input type="text" name="searchinput" id="searchinput" class="store-search" placeholder="Søk etter stedsnavn" value="<?php echo (isset($_GET['searchinput']) && !empty($_GET['searchinput'])) ? $_GET['searchinput'] : ''; ?>">
                                    <span class="search-wrap__search"></span>
                                </div>
                            </div>
                        </div>

                        <!-- Posts -->
                        <div class="row nyheter all-stores">
                            <?php 
                                $the_query = new WP_Query($args);
                                if($the_query->have_posts()){
                                    while ($the_query->have_posts()) {
                                        $the_query->the_post();
                                        $postid = get_the_ID();

                                        if( is_page_template("template-storelocator.php") ) {
                                            $post_link = get_permalink($postid);
                                        } else {
                                            $post_link = get_field('nettside', $postid);
                                        }
                                        

                                        //get_post_meta($postid, 'kontakt-url', true) ? get_post_meta($postid, 'kontakt-url', true) : "#"
                                        ?>
                                        <div class="col-sm-6 col-xl-4 nyhet">
                                            <a href="<?php echo $post_link; ?>">
                                                <div class="nyhet-inner">
                                                    <!-- Map -->
                                                    <div class="map-image image" id="store-id-<?php echo $postid; ?>"></div>
                                                    <div class="nyhet-inner__wrapper">
                                                        <h3><?php the_title(); ?></h3>
                                                        <?php if(get_post_meta($postid, 'adresse', true)): ?><p><?php echo get_post_meta($postid, 'adresse', true) ?></p><?php endif;?>
                                                        <?php 
                                                        $utvidet_informasjon = get_post_meta($postid, 'utvidet_informasjon', TRUE);
                                                        if($utvidet_informasjon){
                                                            ?>
                                                            <p><?php echo $utvidet_informasjon; ?></p>
                                                            <?php
                                                        }   
                                                        ?>
                                                        <span class="read-more"><?php _e('Kontakt Oss','sefbo');?></span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <?php
                                    }
                                    wp_reset_postdata();
                                }
                                else{ ?>
                                    <div class="col-lg-12 col-xl-12 no-stores">
                                        <p><?php esc_html_e( 'Ingen butikker ble funnet som samsvarer med utvalget ditt.', 'sefbo' ); ?></p>
                                    </div>
                                <?php }
                            ?>

                            <!-- <div class="col-lg-6 col-xl-4 nyhet">
                                <a href="#">
                                    <div class="nyhet-inner"> -->
                                        <!-- Map -->
                                        <!-- <div class="image">

                                        </div>
                                        <h3>Lorem Ipsum dollar amet</h3>
                                        <p>Address</p>
                                        <span class="read-more"><?php _e('Kontakt Oss','sefbo');?></span>
                                    </div>
                                </a>
                            </div> -->
                        </div>

                    </div>

                </div>

                <div class="col-lg-5 support-content">

                    <div class="sidebar" id="contact">
                          <h2 class="store-locator__heading mt-0">
                                <?php _e('Kontakt vårt sentralbord','sefbo');?>
                            </h2>
                        <div class="contact-info-wrap">
                            <ul>
                                <li class="address"><?php the_field('adresse','option') ?></li>
                                <li class="phone"><a href="tel:<?php the_field('telefon','option') ?>"><?php the_field('telefon','option') ?></a></li>
                                <li class="email"><a href="mailto:<?php the_field('e-post','option') ?>"><?php the_field('e-post','option') ?></a></li>
                            </ul>
                        </div>

                        <div class="form-wrap">
                        <?php hent_skjema(get_field('kontaktskjema','option')); ?>
                        </div>

                        <div class="ansatte">
                            <?php 
                            if( have_rows('ansatt','option') ):
                                while( have_rows('ansatt','option') ) : the_row();
                                    $bilde = get_sub_field('bilde');
                                    $navn = get_sub_field('navn__tittel');
                                    $stilling = get_sub_field('stilling');
                                    $telefon = get_sub_field('telefon');
                                    $epost = get_sub_field('e-post');

                                ?>
                                    <div class="rad">
                                        <div class="ansatt-column-1">
                                            <div class="ansatt-image" style="background-image:url('<?php echo $bilde['url']; ?>')"></div>
                                        </div>

                                        <div class="ansatt-column-2">
                                            <div class="column-inner">
                                                <h2><?php echo $navn; ?></h2>
                                                <span><?php echo $stilling; ?></span>
                                                <a href="tel:<?php echo $telefon; ?>"><?php echo $telefon; ?></a>
                                                <a href="mailto:<?php echo $epost; ?>"><?php echo $epost; ?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php 

                                endwhile;
                                
                            endif;

                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
    </section>

    <?php endwhile; ?>

<?php //wp_reset_postdata(); ?>

<?php get_footer(); ?>
