<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <title><?php wp_title(); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">    
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

    <?php wp_head(); ?>
    
    <script src="https://kit.fontawesome.com/67b984c5ca.js" crossorigin="anonymous"></script>
</head>

<?php
$GLOBALS['post_id'] = get_the_ID(); //define global post_id variable for later use: content-slidein-product-single.php
$bodyclass[] = "nav-down";
if(is_page_template('page-nettbutikkforside.php')):
$bodyclass[] = "woocommerce";
endif;
?>

<body <?php body_class($bodyclass); ?>>

<header>
    <div class="container-fluid">
        <div class="rad">
            <div class="logo-column">
                <a href="/">
                    <img loading="lazy" class="logo" src="<?php echo get_field('selskap_logo')['url']; ?>" alt="Selskap Logo">
                </a>
            </div>
            <div class="menu-column">
                <ul class="utility-menu">
                    <li class="menu-item back-to-sefbo">
                        <a href="<?php echo site_url(); ?>"><?php _e('Tilbake til Sefbo AS')  ?></a>
                    </li>

                    <li class="menu-item contact">
                        <a class="sefbo-btn header orange scroll-to" href="#contact"><?php echo get_field('knappetekst','option');  ?></a>
                    </li>

                    <li class="hamburger">
                        <a class="menu-toggle" onclick="hamburger_open()" href="javascript:void(0);">
                            <span class="first"></span>
                            <span class="second"></span>
                            <span class="last"></span>
                        </a>
                    </li>
                </ul>
            </div>
          
        </div>
    </div>
</header>



<div class="mobile-menu">

    <?php if (has_nav_menu('mobile_menu')): ?>
        <?php wp_nav_menu(array(
            'theme_location' => 'mobile_menu',
            'container' => false,
            'menu_class' => 'mobile_menu mobil'
        )); ?>
    <?php endif; ?>

</div>



