<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <title><?php wp_title(); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">    
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

    <?php wp_head(); ?>
    
    <script src="https://kit.fontawesome.com/67b984c5ca.js" crossorigin="anonymous"></script>
</head>



<?php
$GLOBALS['post_id'] = get_the_ID(); //define global post_id variable for later use: content-slidein-product-single.php
$bodyclass[] = "nav-down";
if(is_page_template('page-nettbutikkforside.php')):
$bodyclass[] = "woocommerce";
endif;
?>

<body <?php body_class($bodyclass); ?>>

<header>
    <div class="container-fluid">
        <div class="rad">

            <div class="logo-column">
                <a href="/">
                    <img loading="lazy" class="sefbo logo" src="<?php echo get_field('logo','option')['url']; ?>" alt="SEFBO AS Logo">
                </a>
            </div>

            <div class="menu-column">
                <?php if (has_nav_menu('main_menu')): ?>
                    <?php wp_nav_menu(array(
                        'theme_location' => 'main_menu',
                        'container' => false,
                        'menu_class' => 'mainmenu desktop-menu'
                    )); ?>
                <?php endif; ?>

                <ul class="utility-menu">
                    <li class="search-toggle menu-item">
                        <a href="javascript:void(0)">
                            <img loading="lazy" src="<?php echo get_stylesheet_directory_uri().'/images/search.svg'; ?>" alt="Sefbo search icon">
                            <span class="search-text">Søk</span>
                        </a>
                    </li>

                    <!--<li class="menu-item cart">
                        <a href="<?php echo wc_get_cart_url(); ?>">
                            <div class="cart-icon-wrap">
                                <img loading="lazy" src="<?php echo get_stylesheet_directory_uri().'/images/cart.svg'; ?>" alt="Sefbo cart icon">
                                <?php $count = WC()->cart->get_cart_contents_count(); ?>    
                                <div class="count-container">
                                    <span class="count"><?php echo $count; ?></span>
                                </div>
                            
                            </div>
                            <span class="cart-text">Handlekurv</span>
                        </a>
                    </li>-->

                    <li class="menu-item contact">
                        <?php if(is_user_logged_in()): ?>
                            <a class="sefbo-btn header orange" href="<?php echo wp_logout_url( '/' ); ?>">Logg ut</a>
                        <?php else: ?>
                            <a class="sefbo-btn header orange<?php if(!get_field('link','option')): echo " slidein-contact"; endif; ?>" <?php if(get_field('link','option')): echo 'href="'.get_field('link','option').'"'; else:  echo 'href="javascript:void(0);"';  endif; ?>><?php echo get_field('knappetekst','option');  ?></a>
                        <?php endif; ?>
                    </li>
                    <li class="hamburger">
                        <a class="menu-toggle" onclick="hamburger_open()" href="javascript:void(0);">
                            <span class="first"></span>
                            <span class="second"></span>
                            <span class="last"></span>
                        </a>
                    </li>
                </ul>
            </div>

        </div>
    </div>
</header>
<?php 
get_search_form();
?>

<div class="mobile-menu">
    <div class="mobile-menu-inner">

    <?php if (has_nav_menu('mobile_menu')): ?>
        <?php wp_nav_menu(array(
            'theme_location' => 'mobile_menu',
            'container' => false,
            'menu_class' => 'mobile_menu mobil-menu'
        )); ?>
    <?php endif; ?>

    <a class="mobile-menu-contact-btn slidein-contact" href="javascript:void(0);">Kontakt oss</a>
    
    </div>
</div>

