<?php 

function register_my_menus() {
    register_nav_menus(
      array(
        'main_menu'     => __( 'Hovedmeny'),
        'mobile_menu'   => __( 'Mobilmeny / Responsive'),
        'footer_1'      => __( 'Footer meny 1'),
        'footer_2'      => __( 'Footer meny 2'),
        'footer_3'      => __( 'Footer meny 3'),
        'footer_4'      => __( 'Footer meny mobil'),
       )
     );
}
add_action( 'init', 'register_my_menus' );


//function to return menu name with location arguement argument
function get_menu_name($location) {

  $menu_location = $location;
  
  $menu_locations = get_nav_menu_locations();
  
  $menu_object = (isset($menu_locations[$menu_location]) ? wp_get_nav_menu_object($menu_locations[$menu_location]) : null);
  
  $menu_name = (isset($menu_object->name) ? $menu_object->name : '');
  
  return $menu_name;

}


add_action('acf/init', 'my_acf_op_init');

function my_acf_op_init() {

    // Check function exists.
    if( function_exists('acf_add_options_sub_page') ) {

        // Add parent.
        $parent = acf_add_options_page(array(
          'page_title' 	=> 'SEFBO Innstillinger',
          'menu_title' 	=> 'SEFBO',
          'menu_slug' 	=> 'innstillinger',
          'icon_url' => 'dashicons-admin-tools',
        ));

        // Add sub page.
        $child = acf_add_options_sub_page(array(
          'page_title'  => __('Generelt'),
          'menu_title'  => __('Generelt'),
          'parent_slug' => $parent['menu_slug'],
        ));

        // Add sub page.
        $child = acf_add_options_sub_page(array(
            'page_title'  => __('Kontaktinfo'),
            'menu_title'  => __('Kontaktinfo'),
            'parent_slug' => $parent['menu_slug'],
        ));

        // Add sub page.
        $child = acf_add_options_sub_page(array(
          'page_title'  => __('Footerinfo / bunnlinje'),
          'menu_title'  => __('Footerinfo'),
          'parent_slug' => $parent['menu_slug'],
        ));

        // Add sub page.
        $child = acf_add_options_sub_page(array(
          'page_title'  => __('Slidein skjema for produktforespørsel / kontakthenvendelser'),
          'menu_title'  => __('Slidein skjema'),
          'parent_slug' => $parent['menu_slug'],
        ));

        // Add sub page.
        $child = acf_add_options_sub_page(array(
          'page_title'  => __('Kontaktpunkter på mobil'),
          'menu_title'  => __('Mobilknapper'),
          'parent_slug' => $parent['menu_slug'],
        ));
        
        
    }
    
}

// add a sub menu dynamically via code!
function selskaper_custom_menu( $items, $args ) {
    $terms_arr = fetch_selskaper_posts_for_menu();
    if(count($terms_arr)){
        foreach($items as $item){
            if(in_array("selskaper", $item->classes)){
                
                $ID = $item->ID;                
                foreach($terms_arr as $term_id => $term_array){
                    $nav_array = array (
                        'title'            => $term_array['term_title'],
                        'menu_item_parent' => $ID,
                        'ID'               => "region_" . $term_id . "_" . $ID,
                        'db_id'            => "region_" . $term_id . "_" . $ID,
                        'url'              => "#",
                        'target'           => '',
                        'xfn'              => '',
                        'current'          => ''
                    );

                    $items[] = (object) $nav_array;
                    foreach($term_array['posts'] as $post_id => $post){

                        if( is_page_template("template-storelocator.php") ) {
                            $post_link = $post['post_url'];
                        } else {
                            $post_link = get_field('nettside', $post_id);
                        }

                        $nav_sub_array = array (
                            'title'            => $post['post_title'],
                            'menu_item_parent' => "region_" . $term_id . "_" . $ID,
                            'ID'               => "post_" . $post_id . "_" . $ID,
                            'db_id'            => "post_" . $post_id . "_" . $ID,
                            'url'              => $post_link,
                            'target'           => '',
                            'xfn'              => '',
                            'current'          => ''
                        );                       
                        $items[] = (object) $nav_sub_array;
                        
                    } 
                }                
            }
        }
    }
    
    return $items;
}
add_filter( 'wp_nav_menu_objects', 'selskaper_custom_menu', 10, 2 );

function fetch_selskaper_posts_for_menu(){
    $terms = get_terms(
        array(
            'taxonomy' => 'region_selskaper',
            'hide_empty' => true
        )
    );
    
    $term_array = array();    

    if(count($terms)){
        foreach($terms as $term){
            $term_id = $term->term_id;
            $term_array[$term_id]['term_title'] = $term->name;
            $term_array[$term_id]['term_link'] = get_term_link($term_id,'region_selskaper');
            
            $args = array(
                'post_status' => 'publish',
                'post_type' => 'selskaper',
                'posts_per_page' => -1,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'region_selskaper',
                        'field' => 'term_id',
                        'terms' => array($term_id),
                        'operator' => 'IN'
                    )
                )
            );

            $query = new WP_Query($args);
            if($query->have_posts()){
                while($query->have_posts()){
                    $query->the_post();
                    $id = get_the_ID();
                    $term_array[$term_id]['posts'][$id]['post_title'] = get_the_title();
                    $term_array[$term_id]['posts'][$id]['post_url'] = get_the_permalink($id);
                }
            }
            wp_reset_query();
        }
    }
    
    return $term_array;
}

