<?php 

function product_get_filter_params($method='POST') {
    if($method=='GET') {
        global $_GET;
    }

    $valid_params = array('search','tax');      

    $_ARR = $method=='POST'? $_POST: $_GET;

    $filter_params = array();
    foreach($valid_params as $param) {
        if(isset($_ARR[$param])) {
            $filter_params[$param] = $_ARR[$param];
        }
    }

    return $filter_params;
}

function search_get_filter_params($method='POST') {
    if($method=='GET') {
        global $_GET;
    }

    $valid_params = array('tax');      

    $_ARR = $method=='POST'? $_POST: $_GET;

    $filter_params = array();
    foreach($valid_params as $param) {
        if(isset($_ARR[$param])) {
            $filter_params[$param] = $_ARR[$param];
        }
    }

    return $filter_params;
}
 
function get_archive_query($page_no, $post_type, $filter_params, $is_ajax=true){
    $tax_query_args = array();
    
    extract($filter_params);
    
    $posts_per_page = -1;
    
    $args = array(
        'post_type' => $post_type,
        'orderby' => 'post_date',
        'post_status' => 'publish',
        'posts_per_page' => $posts_per_page,
        'paged' => $page_no,
    );
    
   if(!empty($search)) {
        $args['s'] = $search;
   }

   if(!empty($tax)) {       
       if($post_type == 'dokumenter'){
            $tax_query_args[] = array( 'taxonomy' => 'dokument_kategorier', 'field' => 'slug', 'terms' => $tax );
       }
    }

    $user = wp_get_current_user(); 

    $roles = $user->roles[0];

    if ( in_array( 'daglig_leder', (array) $user->roles ) || in_array( 'shop_manager', (array) $user->roles )){
        $meta_query_args[] = array(
            'relation' => 'OR',
            array(
                'key' => 'tilgjengelig_kun_for_dl',
                'value' => 1,
                'compare' => 'LIKE'
            ),
            array(
                'key' => 'tilgjengelig_kun_for_dl',
                'value' => 0,
                'compare' => '='
            ),
            array(
                'key' => 'tilgjengelig_kun_for_dl',
                'compare' => 'NOT EXISTS'
            ),
        );
    }else{
        $meta_query_args[] = array(
        'relation' => 'OR',
            array(
                'key' => 'tilgjengelig_kun_for_dl',
                'value' => 0,
                'compare' => 'LIKE'
            ),
            array(
                'key' => 'tilgjengelig_kun_for_dl',
                'compare' => 'NOT EXISTS'
            ),
        );
    }

    $args['meta_query'] = $meta_query_args;
    
    if(count($tax_query_args)) {
        $args['tax_query'] = $tax_query_args;
    }

    

    $the_query = new WP_Query($args);
    return $the_query;
}

function callposthtmldata($the_query, $page_no, $is_ajax = true){
    ob_start();
    $i = 0;
    $filter_params =  search_get_filter_params();

    if ($the_query->have_posts()) { ?>
        <h2><?php echo str_replace("-", " ", $filter_params['tax']) ?></h2>
        <div class="row">
        <?php while ($the_query->have_posts()) {
            $the_query->the_post();     
            global $post; ?>

            
            <?php if(get_field('fil')): ?>
                <div class="col-lg-4 document">
                    <?php $fil = get_field('fil'); 
                        $filetype = substr($fil['filename'] , strpos($fil['filename'] , ".") + 1);
                    ?>
                    <a download href="<?php echo get_field('fil')['url']; ?>"><?php echo $fil['title']." (".$filetype.")"; ?></a>
                </div>
            <?php endif; ?>
           

            
        <?php } ?>
        </div>
        <?php wp_reset_query();
        ?>


        <?php
    }else{
        ?>
       
       <?php 
            echo "<h2>Ingen dokumenter tilgjengelig i denne kategorien</h2>";
        ?>

        <?php
    }
    
    $html_data = ob_get_clean();
    $return_data = array('html'=>$html_data, 'total_pages'=>$the_query->max_num_pages, 'total_records'=>$the_query->found_posts);
    if( ! $is_ajax ){
        return $return_data;
    }else{
        echo json_encode($return_data);
    }
}


add_action( 'wp_ajax_posttriggerfilters', 'post_trigger_filters');
add_action( 'wp_ajax_nopriv_posttriggerfilters', 'post_trigger_filters');
function post_trigger_filters() {
    $page_no = ( !empty($_POST['page_no']) ) ? $_POST['page_no'] : 1;
    $type = ( !empty($_POST['type']) ) ? $_POST['type'] : '';
    $filter_params =  search_get_filter_params();
    $the_query = get_archive_query($page_no, $type, $filter_params, true); 
    if($type == 'dokumenter'){
        callposthtmldata($the_query,$page_no,true);
    }
    exit();
}

function getTermsFromPosts(){

    $user = wp_get_current_user(); 

    $roles = $user->roles[0];

    if ( in_array( 'daglig_leder', (array) $user->roles ) || in_array( 'shop_manager', (array) $user->roles ) ){
        $args =  array(
            'post_type' => 'dokumenter',
            'posts_per_page' => -1,
            'meta_query' => array(
                'relation' => 'OR',
                    array(
                        'key' => 'tilgjengelig_kun_for_dl',
                        'value' => 1,
                        'compare' => 'LIKE'
                    ),
                    array(
                        'key' => 'tilgjengelig_kun_for_dl',
                        'value' => 0,
                        'compare' => '='
                    ),
                    array(
                        'key' => 'tilgjengelig_kun_for_dl',
                        'compare' => 'NOT EXISTS'
                    ),
            ),
        );
    }
    else{
        $args =  array(
            'post_type' => 'dokumenter',
            'posts_per_page' => -1,
            'meta_query' => array(
                'relation' => 'OR',
                    array(
                        'key' => 'tilgjengelig_kun_for_dl',
                        'value' => 0,
                        'compare' => 'LIKE'
                    ),
                    array(
                        'key' => 'tilgjengelig_kun_for_dl',
                        'compare' => 'NOT EXISTS'
                    ),
            ),
        );
    }
    

    $wp_query = new WP_Query( $args );

    $termsInPosts = array();

    if ( $wp_query->have_posts() ) {

        while( $wp_query->have_posts() ) : $wp_query->the_post();

            $postTerms = get_the_terms(get_the_ID(), 'dokument_kategorier', array('fields' => 'term_id'));
            
            foreach ($postTerms as $postTerm)
                if (!in_array($postTerm->term_id, $termsInPosts))
                    $termsInPosts[] = $postTerm->term_id;
            
        endwhile;

        wp_reset_postdata();
        
    } 

    return $termsInPosts;
   
}