<?php 

function post_types_init() {

    register_post_type('tjenester', array(
        'labels' => array(
            'menu_name' => __('Tjenester'),
            'name' => __('Tjenester'),
            'singular_name' => __('Tjeneste'),
            'add_new_item' => __('Legg til ny tjeneste'),
        ),
        'supports'          => array('title', 'thumbnail',"editor",'excerpt','page-attributes'),
        'public'            => true,
        'menu_icon'         => 'dashicons-editor-paste-text',
        'has_archive'       => false,
        'hierarchical'      => true,
        )
    );

    register_post_type('selskaper', array(
        'labels' => array(
            'menu_name' => __('Selskaper'),
            'name' => __('Selskaper'),
            'singular_name' => __('Selskap'),
            'add_new_item' => __('Legg til nytt Selskap'),
        ),
        'supports'          => array('title', 'thumbnail',"editor",'excerpt'),
        'public'            => true,
        'menu_icon'         => 'dashicons-businessman',
        'has_archive'       => false,
        )
    );

    register_post_type('kontaktgrupper', array(
        'labels' => array(
            'menu_name' => __('Kontaktgrupper'),
            'name' => __('Kontaktgrupper'),
            'singular_name' => __('Kontaktgrupper'),
            'add_new_item' => __('Legg til nytt Kontaktgrupper'),
        ),
        'supports'          => array('title'),//array('title','thumbnail',"editor",'excerpt'),
        'public'            => true,
        'menu_icon'         => 'dashicons-businessman',
        'has_archive'       => false,
        )
    );

    register_post_type('internnyheter', array(
        'labels' => array(
            'menu_name' => __('Internnyheter'),
            'name' => __('Internnyheter'),
            'singular_name' => __('Internnyhet'),
            'add_new_item' => __('Legg til internnyhet'),
        ),
        'supports'          => array('title', 'thumbnail',"editor",'excerpt'),
        'public'            => true,
        'menu_icon'         => 'dashicons-welcome-write-blog',
        'has_archive'       => false,
        'show_in_rest'      => true,
        )
    );

    register_post_type('dokumenter', array(
        'labels' => array(
            'menu_name' => __('Dokumenter'),
            'name' => __('Dokumenter'),
            'singular_name' => __('Dokument'),
            'add_new_item' => __('Legg til nytt dokument'),
        ),
        'supports'          => array('title', 'thumbnail',"editor",'excerpt'),
        'public'            => true,
        'menu_icon'         => 'dashicons-archive',
        'has_archive'       => false,
        'show_in_rest'      => true,
        )
    );

}

add_action('init', 'post_types_init');

function filter_product_wpseo_title($title) {

    if(is_post_type_archive('tjenester')) {
        $title = "Tjenester | Sefbo AS";
    }

    if(is_post_type_archive('post')) {
        $title = "Nyheter | Sefbo AS";
    }

    return $title;

}

add_filter('wpseo_title', 'filter_product_wpseo_title');



function add_rewrite_rules( $wp_rewrite )
{
    $new_rules = array(
        'historier/(.+?)/?$' => 'index.php?post_type=post&name='. $wp_rewrite->preg_index(1),
    );

    $wp_rewrite->rules = $new_rules + $wp_rewrite->rules;
}
//add_action('generate_rewrite_rules', 'add_rewrite_rules'); 

function change_post_links($post_link, $id=0){

    $post = get_post($id);

    if( is_object($post) && $post->post_type == 'post'){
        return home_url('/historier/'. $post->post_name.'/');
    }

    return $post_link;
}
//add_filter('post_link', 'change_post_links', 1, 3);


// Change dashboard Posts to News
function cp_change_post_object() {
    $get_post_type = get_post_type_object('post');
    $labels = $get_post_type->labels;
        $labels->name = 'Nyheter';
        $labels->singular_name = 'Nyheter';
        $labels->add_new = 'Ny nyhet';
        $labels->add_new_item = 'Legg til nyhet';
        $labels->edit_item = 'Rediger nyhet';
        $labels->new_item = 'Ny nyhet';
        $labels->view_item = 'Se nyheten';
        $labels->search_items = 'Søk i nyheten';
        $labels->not_found = 'Ingen nyheter funnet..';
        $labels->not_found_in_trash = 'Ingen nyheter funnet i papirkurven';
        $labels->all_items = 'Alle nyheter';
        $labels->menu_name = 'Nyheter';
        $labels->name_admin_bar = 'Nyheter';
}
add_action( 'init', 'cp_change_post_object' );



/* Exclude Multiple Content Types From Yoast SEO Sitemap */
add_filter( 'wpseo_sitemap_exclude_post_type', 'sitemap_exclude_post_type', 10, 2 );

function sitemap_exclude_post_type( $value, $post_type ) {

    $post_type_to_exclude = array('dokumenter','internnyheter');

    if( in_array( $post_type, $post_type_to_exclude ) ) 
        return true;
        
}


add_filter( 'manage_internnyheter_posts_columns', 'filter_internnyheter_columns' );
function filter_internnyheter_columns( $columns ) {
  $columns['kun_for_dl'] = __( 'Kun for dl?' );
  return $columns;
}

add_action( 'manage_internnyheter_posts_custom_column', 'internnyheter_column', 10, 2);
function internnyheter_column( $column, $post_id ) {
    if ( 'kun_for_dl' === $column ) {
        if(get_field('tilgjengelig_kun_for_dl', $post_id)){
            echo "&#10003;";
        }
    }
}



add_filter( 'manage_dokumenter_posts_columns', 'filter_dokumenter_columns' );
function filter_dokumenter_columns( $columns ) {
  $columns['kun_for_dl'] = __( 'Kun for dl?' );
  return $columns;
}

add_action( 'manage_dokumenter_posts_custom_column', 'dokumenter_column', 10, 2);
function dokumenter_column( $column, $post_id ) {
    if ( 'kun_for_dl' === $column ) {
        if(get_field('tilgjengelig_kun_for_dl', $post_id)){
            echo "&#10003;";
        }
    }
}