<?php 

/********************************/
/*    styles & Scripts          */
/********************************/

function enqueue_scripts(){

    //Styles
    wp_enqueue_style('Bootstrap-style', get_stylesheet_directory_uri().'/bootstrap/bootstrap.css', "4.1.4");

    wp_enqueue_style('slick', get_stylesheet_directory_uri() . '/slick/slick.css', '', filemtime(get_stylesheet_directory() . '/slick/slick.css'));  //slider library

    wp_enqueue_style('slick-theme', get_stylesheet_directory_uri() . '/slick/slick-theme.css', '', filemtime(get_stylesheet_directory() . '/slick/slick-theme.css')); //slider library

    //wp_enqueue_style('aos-style', get_stylesheet_directory_uri() . '/aos/aos.css', '', '1.0.0'); //fade up library

    wp_enqueue_style('theme-styles', get_stylesheet_directory_uri() . '/css/theme-styles.css', '', filemtime(get_stylesheet_directory() . '/css/theme-styles.css'));

    //scripts
    wp_enqueue_script('bootstrap-js', get_stylesheet_directory_uri().'/js/bootstrap/bootstrap.min.js', array('jquery'), '4.1.3', true);

    wp_enqueue_script('waypoints', get_stylesheet_directory_uri() . '/js/jquery.waypoints.min.js', array('jquery'), '1.0.0' , true);
    
    wp_enqueue_script('object-fit', get_stylesheet_directory_uri() . '/js/ofi.min.js', array('jquery'), '1.0.0', true);

    //wp_register_script("aos-js", get_stylesheet_directory_uri() . '/aos/aos.js', array('jquery'), '1.0.1', true); //fade up library

    //wp_enqueue_script('aos-js'); //fade up library

    wp_enqueue_script('scripts-min-js', get_stylesheet_directory_uri().'/js/scripts.min.js', array('jquery') ,filemtime(get_stylesheet_directory() . '/js/scripts.min.js'), true );

    wp_enqueue_script('load-more-js', get_stylesheet_directory_uri().'/js/load_more.min.js', array('jquery') ,filemtime(get_stylesheet_directory() . '/js/load_more.min.js'), true );

    wp_enqueue_script('slick-js', get_stylesheet_directory_uri().'/slick/slick.min.js',filemtime(get_stylesheet_directory().'/slick/slick.min.js'), true);  //slider library

    wp_localize_script('scripts-min-js', "adminajax", array("ajax_url" => admin_url('admin-ajax.php')));

    wp_enqueue_script('google-maps-api', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDqKxKEpyTP8soj3hPDH6-ZEuBY4E3kkOY');


    wp_enqueue_script('marker-cluster-api', get_stylesheet_directory_uri().'/js/cluster.js');
    //wp_enqueue_script('marker-cluster-api', 'https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js');
    //wp_enqueue_script('marker-cluster-api', 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js');

    //wp_enqueue_script('marker-cluster-api', 'https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js');
    wp_enqueue_script('marker-cluster-api', get_stylesheet_directory_uri().'/js/cluster.js');

    
    wp_enqueue_script('store-locator-js', get_stylesheet_directory_uri().'/js/slocator.js', array('jquery') ,filemtime(get_stylesheet_directory() . '/js/slocator.js'), true );
    
    wp_localize_script('store-locator-js', "adminajax", array("ajax_url" => admin_url('admin-ajax.php')));

} 

add_action( 'wp_enqueue_scripts', 'enqueue_scripts' );


