<?php

add_action("wp_ajax_filter_slocator", "filter_slocator");
add_action("wp_ajax_nopriv_filter_slocator", "filter_slocator");

function filter_slocator() {
    global $wpdb;

    // $variable1 = $_REQUEST['search'];
    $filter_region = $_REQUEST['filter_region'];
    $lat = $_REQUEST['lat'];
    $lng = $_REQUEST['lng'];
    
    $i = 0;
    $q1 = $q2 = array();
    $location_distance = array();
    $unique = array();

    // $args = array(
    //     'post_type' => 'selskaper',
    //     'post_status' => 'publish',
    //     // 's' => $variable1,
    //     'posts_per_page' => -1,
    //     'fields' => 'ids',
    // );

    $args = array(
        'post_type' => 'selskaper',
        'post_status' => 'publish',
        'posts_per_page' => -1,
    );

    $distance_unit = '6371';
    if ($lat && $lng) {
        $sql = "SELECT posts.ID,
                    ( $distance_unit * acos( cos( radians('" . $lat . "') ) * cos( radians( postmeta.meta_value ) ) * cos( radians( postmeta1.meta_value ) - radians('" . $lng . "') ) + sin( radians('" . $lat . "') ) * sin( radians( postmeta.meta_value ) ) ) ) AS distance 
                    FROM {$wpdb->prefix}posts posts
                    LEFT JOIN {$wpdb->prefix}postmeta postmeta		
                    ON posts.ID = postmeta.post_id
                    LEFT JOIN {$wpdb->prefix}postmeta postmeta1		
                    ON posts.ID = postmeta1.post_id
                    WHERE 1 AND postmeta.meta_key = 'latitude' and postmeta1.meta_key = 'longitude' AND posts.post_type = 'selskaper' AND posts.post_status = 'publish' AND ( $distance_unit * acos( cos( radians('" . $lat . "') ) * cos( radians( postmeta.meta_value ) ) * cos( radians( postmeta1.meta_value ) - radians('" . $lng . "') ) + sin( radians('" . $lat . "') ) * sin( radians( postmeta.meta_value ) ) ) )<100 ORDER BY distance";
        $locations = $wpdb->get_results($sql, 'ARRAY_A');

        foreach ($locations as $location) {
            $unique[] = $location['ID'];
            // $location_distance[$location['ID']] = $location['distance'];
        }

        if($unique){
            $args['post__in'] = $unique;
            $args['orderby'] = 'post__in';
            $args['order'] = 'ASC';
        }
        else{
            $args['post__in'] = array(0);
        }
    }
    
    /*
    if($variable1){
        $q1 = get_posts($args);

        //post meta for address details
        $q2 = get_posts(array(
            'post_type' => 'selskaper',
            'post_status' => 'publish',
            'posts_per_page' => -1,
            'fields' => 'ids',
            'meta_query' => array(
                'relation' => 'OR',
                array(
                    'key' => 'adresse',
                    'value' => $variable1,
                    'compare' => 'LIKE'
                ),
            )
        ));
    }
    
    $merged = array_merge($q1, $q2);
    
    $post_ids = array();

    foreach ($merged as $item) {
        $post_ids[] = $item;
    }

    $unique = array_unique($merged);

    if (!$unique) {
        $unique = array('0');
    }
   
    if($unique && $variable1){
        $args['post__in'] = $unique;
    }
    */

    if(!empty($filter_region)){
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'region_selskaper',
                'field' => 'slug',
                'terms' => [$filter_region]
            ),
        );
    }

    //var_dump($args);

    $the_query = new WP_Query($args);
    $htmlval = "";

    if($the_query->have_posts()){
        while ($the_query->have_posts()) {
            $the_query->the_post();

            $postid = get_the_ID();
            $title = get_the_title();
            $place = get_post_meta($postid, 'adresse', TRUE);
            $lat = get_post_meta($postid, 'latitude', TRUE);
            $lng = get_post_meta($postid, 'longitude', TRUE);

            $content = "<div class='marker_info'><h4 class='marker_info__title'>".$title."</h4><p class='marker_info__addr'>".$place."</p><a class='link' href='".get_the_permalink($postid)."'>".__('Kontakt Oss','sefbo')."</a></div>";

            $htmlval .= "<div class='col-sm-6 col-xl-4 nyhet'>";
                $htmlval .= "<a href='".(get_post_meta($postid, 'kontakt-url', true) ? get_post_meta($postid, 'kontakt-url', true) : "#")."'>";
                    $htmlval .= "<div class='nyhet-inner'>";
                        $htmlval .= "<div class='map-image image' id='store-id-".$postid."'></div>";
                        $htmlval .= "<div class='nyhet-inner__wrapper'><h3>".get_the_title()."</h3>";
                        $htmlval .= "<p>".get_post_meta($postid, 'adresse', true)."</p>";
                        $htmlval .= "<span class='read-more'>".__('Kontakt Oss','sefbo')."</span>";
                    $htmlval .= "</div></div>";
                $htmlval .= "</a>";
            $htmlval .= "</div>";
            
            $myarray[] = array('address' => $place, "content" => $content, 'id' => $postid, 'lat' => $lat, 'long' => $lng);
            
            $i++;
        }
        wp_reset_postdata();
    }
    else{
        $htmlval = '<div class="col-lg-12 col-xl-12 no-stores"><p>'.__( 'Ingen butikker ble funnet som samsvarer med utvalget ditt.', 'sefbo' ).'</p></div>';
    }
    
    $result['message'] = $htmlval;
    $result['fulldata'] = $myarray;
    // $result['unique'] = $unique;

    $result = json_encode($result);
    echo $result;

    die();
}
