<?php 

function register_taxonomies() {

    $labels = array(
		'name' => _x('Kategori', 'taxonomy general name'),
		'singular_name' => _x('Kategori', 'taxonomy singular name'),
		'search_items' => __('Søk i kategorier'),
		'all_items' => __('Alle kategorier'),
		'parent_item' => __('Parent kategori'),
		'parent_item_colon' => __('Parent kategori:'),
		'edit_item' => __('Endre kategori'),
		'update_item' => __('Oppdater kategori'),
		'add_new_item' => __('Ny kategori'),
		'new_item_name' => __('Ny kategori'),
		'menu_name' => __('Kategorier'),
	);

	$args = array(
		'show_admin_column' => true,
		'hierarchical' => true,
		'labels' => $labels,
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_quick_edit' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'kategori'),
    );
    
    register_taxonomy('kategorier', array('tjenester'), $args);
    
     $labels2 = array(
		'name' => _x('Kategori', 'taxonomy general name'),
		'singular_name' => _x('Kategori', 'taxonomy singular name'),
		'search_items' => __('Søk i kategorier'),
		'all_items' => __('Alle kategorier'),
		'parent_item' => __('Parent kategori'),
		'parent_item_colon' => __('Parent kategori:'),
		'edit_item' => __('Endre kategori'),
		'update_item' => __('Oppdater kategori'),
		'add_new_item' => __('Ny kategori'),
		'new_item_name' => __('Ny kategori'),
		'menu_name' => __('Kategorier'),
	);

	$args2 = array(
		'show_admin_column' => true,
		'hierarchical' => true,
		'labels' => $labels2,
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_quick_edit' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'dokument_kategori'),
		'show_in_rest' => true,
    );
    
    register_taxonomy('dokument_kategorier', array('dokumenter'), $args2);
	

	$labels3 = array(
		'name' => _x('Region', 'taxonomy general name'),
		'singular_name' => _x('Region', 'taxonomy singular name'),
		'search_items' => __('Søk i region'),
		'all_items' => __('Alle regions'),
		'parent_item' => __('Parent Region'),
		'parent_item_colon' => __('Parent Region:'),
		'edit_item' => __('Endre region'),
		'update_item' => __('Oppdater region'),
		'add_new_item' => __('Ny region'),
		'new_item_name' => __('Ny region'),
		'menu_name' => __('Region'),
	);

	$args3 = array(
		'show_admin_column' => true,
		'hierarchical' => true,
		'labels' => $labels3,
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_quick_edit' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'region_selskaper'),
		'show_in_rest' => true,
    );
    
    register_taxonomy('region_selskaper', array('selskaper'), $args3);   
}

add_action('init', 'register_taxonomies');


/* Exclude One Taxonomy From Yoast SEO Sitemap */
add_filter( 'wpseo_sitemap_exclude_taxonomy', 'sitemap_exclude_taxonomy', 10, 2 );

function sitemap_exclude_taxonomy( $value, $taxonomy ) {
	if ( $taxonomy == 'dokument_kategorier' ) return true;
}
