<?php 

//Disable gutenberg
//add_filter('use_block_editor_for_post', '__return_false', 10);


function mytheme_post_thumbnails() {
  add_theme_support( 'post-thumbnails' ); //Featured image
  //add_post_type_support( 'page', 'excerpt' ); //Excerpt på page

  add_theme_support( 'wc-product-gallery-lightbox' );
  add_theme_support( 'wc-product-gallery-zoom' );
  add_theme_support('woocommerce');
}

add_action( 'after_setup_theme', 'mytheme_post_thumbnails' );

remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

// Added to extend allowed files types in Media upload
function custom_upload_mimes ( $mimes=array() ){

  // Add *.EPS files to Media upload
  $mimes['eps'] = 'application/postscript';
  $mimes['psd']  = 'image/vnd.adobe.photoshop';
  $mimes['svg'] = 'image/svg+xml';
  // Add *.AI files to Media upload
  $mimes['ai'] = 'application/postscript';
  //tiff
  $mimes['tiff'] = 'image/tiff'; 

  $mimes['jpeg'] = 'image/jpeg'; 

  return $mimes;

}

add_filter('upload_mimes', 'custom_upload_mimes', 1, 1);


function theme_redirection() {

  // if( is_singular('selskaper') ) {
  //   if(get_field('nettside')) : wp_redirect( get_field('nettside') ); die; endif;
  // }

  if(is_user_logged_in() && is_account_page()){
    header( "location: " . get_permalink ( get_page_id_by_template('page-internnytt.php')[0] ) );  
    die;
  }
  
}

add_action( 'template_redirect', 'theme_redirection' );
 
function hent_skjema ($skjema_id){
  gravity_form( 
    $skjema_id, 
    $display_title = false, 
    $display_description = false, 
    $display_inactive = false, 
    $field_values = null, 
    $ajax = true, 
    $tabindex = -1, 
    $echo = true 
  ); 
}

/**
 * Returns page id by template file name
 *
 * @param string $template name of template file including .php
 */

function get_page_id_by_template( $template ) {
  $args = [
      'post_type'  => 'page',
      'fields'     => 'ids',
      'nopaging'   => true,
      'meta_key'   => '_wp_page_template',
      'meta_value' => $template
  ];
  $pages = get_posts( $args );
  return $pages;
}


function login_redirect( $redirect, $user ) {

  $redirect = get_permalink ( get_page_id_by_template('page-internnytt.php')[0] );

  return $redirect;

}

add_filter( 'woocommerce_login_redirect', 'login_redirect', 9999, 2 );



// Remove comments page in menu
add_action('admin_menu', function () {
  remove_menu_page('edit-comments.php');
});


$roleObject = get_role( 'editor' );
if (!$roleObject->has_cap( 'edit_theme_options' ) ) {
    $roleObject->add_cap( 'edit_theme_options' );
}


/* * * New user role ** */
add_role('ansatt', 'Ansatt', array(
  'read' => true, // True allows that capability
  'edit_posts' => false,
  'delete_posts' => false, // Use false to explicitly deny
));

/* * * New user role ** */
add_role('daglig_leder', 'Daglig leder', array(
  'read' => true, // True allows that capability
  'edit_posts' => false,
  'delete_posts' => false, // Use false to explicitly deny
));




function add_roles_to_create_users_for_shop_manager( $roles ) {
  $roles = array('daglig_leder', 'ansatt');
  return $roles;
}
add_filter( 'woocommerce_shop_manager_editable_roles', 'add_roles_to_create_users_for_shop_manager' ); 

/* Lets Shop Managers be able to edit users again */
function add_shop_manager_user_editing_capability() {
  $shop_manager = get_role( 'shop_manager' );
  $shop_manager->add_cap( 'promote_users' );
  $shop_manager->add_cap( 'create_users' );
  $shop_manager->add_cap( 'edit_users' );
  $shop_manager->add_cap( 'edit_user' );
  $shop_manager->add_cap( 'delete_users');
}

add_action( 'admin_init', 'add_shop_manager_user_editing_capability');



add_filter( 'woocommerce_min_password_strength', 'reduce_min_strength_password_requirement' );
function reduce_min_strength_password_requirement( $strength ) {
    // 3 => Strong (default) | 2 => Medium | 1 => Weak | 0 => Very Weak (anything).
    return 2; 
}



add_action('init', 'get_user_caps');

function get_user_caps() {
 $role_to_copy = get_role('wpseo_manager'); //Get user role to fetch user caps from
 $role_caps= array_keys( $role_to_copy->capabilities ); //Get capabilites from user role
 $role_new_caps = get_role('shop_manager'); //Get the user role you want to add user caps. 
  foreach ( $role_caps as $cap ) {
   $role_new_caps->add_cap( $cap ); //Close user caps. 
  }
}

function wpeagles_example_role_caps()
{
   
  $role = get_role('shop_manager');

    $role->add_cap('gform_full_access', true);
    
   
}

add_action('init', 'wpeagles_example_role_caps', 11);