<?php 

//Arkiv produkt kjøpsknapp
add_filter( 'woocommerce_product_add_to_cart_text', 'woo_custom_product_add_to_cart_text' ); 

function woo_custom_product_add_to_cart_text() {

    global $product;

    if( $product->is_type('variable')){
        return __( 'Gå til produkt', 'woocommerce' );
    }else{
        return __( 'Legg i handlekurven', 'woocommerce' );
    }

}

//Single produkt kjøpsknapp
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woo_custom_single_add_to_cart_text' );  

function woo_custom_single_add_to_cart_text() {
    return __( 'Legg i handlekurven', 'woocommerce' );
}

//Sales badge with percentage
add_filter( 'woocommerce_sale_flash', 'add_percentage_to_sale_badge', 20, 3 );
function add_percentage_to_sale_badge( $html, $post, $product ) {
    if( $product->is_type('variable')){
        $percentages = array();

        // Get all variation prices
        $prices = $product->get_variation_prices();

        // Loop through variation prices
        foreach( $prices['price'] as $key => $price ){
            // Only on sale variations
            if( $prices['regular_price'][$key] !== $price ){
                // Calculate and set in the array the percentage for each variation on sale
                $percentages[] = round(100 - ($prices['sale_price'][$key] / $prices['regular_price'][$key] * 100));
            }
        }
        $percentage = max($percentages) . '%';
    } else {
        $regular_price = (float) $product->get_regular_price();
        $sale_price    = (float) $product->get_sale_price();

        $percentage    = round(100 - ($sale_price / $regular_price * 100)) . '%';
    }
    return '<span class="onsale">' . $percentage . '</span>';
}

//Move salesbadge below product image:
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
add_action('woocommerce_shop_loop_item_title','woocommerce_show_product_loop_sale_flash', 5);


//Update cart count in header:
add_filter( 'woocommerce_add_to_cart_fragments', 'cart_count', 10, 1 );

function cart_count( $fragments ) {
    ob_start();
    ?>
    <?php $count = WC()->cart->get_cart_contents_count(); ?>    
    <?php if($count > 0): ?>
    <span class="count">
            <?php echo WC()->cart->get_cart_contents_count(); ?>
    </span>
    <?php
    else:
        ?>
        <span class="count hidden">
                <?php echo WC()->cart->get_cart_contents_count(); ?>
        </span>
        <?php
    endif;
        $fragments['.count'] = ob_get_clean();
    return $fragments;
}

//remove woocommerce breadcrumbs
remove_filter('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

//Removes tabs, and prints long description at its place
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_after_single_product_summary', 'show_product_long_description', 10 );
  
function show_product_long_description() {
   
    ?>
            </div> <!--ends col-sm-10 -->
        </div> <!--ends row -->
    </div> <!--ends container -->

    <div class="container-fluid content-width">
        <div class="row justify-content-center">
            <div class="col-lg-6 support-content long-description">
                <?php if(get_the_content()){ ?>
                    <h2 class="product-description">Produktbeskrivelse</h2>
                    <?php the_content(); ?>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php
   
}

//remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating');
add_action('woocommerce_single_product_summary', 'show_sku', 6 );

function show_sku(){
    global $product;
    echo '<span class="sku">'.$product->get_sku().'</span>';
}

/*
* @hooked woocommerce_template_single_title - 5
* @hooked woocommerce_template_single_rating - 10
* @hooked woocommerce_template_single_price - 10
* @hooked woocommerce_template_single_excerpt - 20
* @hooked woocommerce_template_single_add_to_cart - 30
* @hooked woocommerce_template_single_meta - 40
* @hooked woocommerce_template_single_sharing - 50
* @hooked WC_Structured_Data::generate_product_data() - 60
*/

//remove product meta
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta',40);

//moved price after expcerpt
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price',10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 28 );



//Remove related products
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

//add a description for how much it saves when sale:
add_action ('woocommerce_single_product_summary','show_savings', 29 );

function show_savings(){

    global $product;

    if( $product->is_type('variable')){
        $savings = array();

        // Get all variation prices
        $prices = $product->get_variation_prices();

        // Loop through variation prices
        foreach( $prices['price'] as $key => $price ){
            // Only on sale variations
            if( $prices['regular_price'][$key] !== $price ){
                // Calculate and set in the array the percentage for each variation on sale
                $savings[] = round(($prices['sale_price'][$key] - $prices['regular_price'][$key]));
            }
        }
    } else {
        $regular_price = (float) $product->get_regular_price();
        $sale_price    = (float) $product->get_sale_price();
        $savings    =  $regular_price - $sale_price;
    }
    if( !empty($sale_price) ){
        echo "<span class='save'>Spar " . $savings . " kr</span>";
    }
}

add_filter( 'woocommerce_show_variation_price', '__return_true' );

add_filter( 'woocommerce_available_variation', 'variable_product_saving_amount', 10, 3 );
function variable_product_saving_amount( $data, $product, $variation ) {

    if( $variation->is_on_sale() ) {
        $saved_amount  = $data['display_regular_price'] - $data['display_price'];
        $percentage    = round( $saved_amount / $data['display_regular_price'] * 100 );

        $data['price_html'] .= '<span class="save">'. __("Spar") .' ' . wc_price($saved_amount) . '</span>';
    }
    return $data;
}

/*
 * custom ajax add to cart
*/
add_action('wp_ajax_woocommerce_ajax_add_to_cart_custom', 'sefbo_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart_custom', 'sefbo_ajax_add_to_cart');
function sefbo_ajax_add_to_cart() {

    $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id);

    if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
            wc_add_to_cart_message(array($product_id => $quantity), true);
        }
        
        $cart_count = WC()->cart->get_cart_contents_count();
        $data = array(
            'error' => false,
            'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id),
            'header_cart_count'=> $cart_count
        );
        WC_AJAX :: get_refreshed_fragments(); // for mini-cart / counter purpose

        echo wp_send_json($data);
    } else {
        $cart_count = WC()->cart->get_cart_contents_count();
        
        $data = array(
            'error' => true,
            'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id),
            'header_cart_count'=> $cart_count
        );
        WC_AJAX :: get_refreshed_fragments(); // for mini-cart / counter purpose
        echo wp_send_json($data);
    }

    wp_die();
}


function woocommerce_template_loop_product_thumbnail(){ ?>
    <?php global $product; ?>
    <?php if ( $product->get_image_id() ) { ?>
        <div class="woocommerce-loop-product__image attachment-woocommerce_thumbnail size-woocommerce_thumbnail" style="background-image:url(
            <?php echo wp_get_attachment_image_src ( get_post_thumbnail_id ( $product->get_id() ), 'large' ) [0]; ?> )">
        </div>
    <?php } else { ?>
        <div class="woocommerce-loop-product__image attachment-woocommerce_thumbnail size-woocommerce_thumbnail" style="background-image:url(
            <?php echo wc_placeholder_img_src( 'woocommerce_single' ); ?> )">
        </div>
    <?php } ?>

        
<?php }


add_filter('woocommerce_variable_price_html', 'custom_variation_price', 10, 2); 

function custom_variation_price( $price, $product ) { 

     $price = '';

     $price .= '<div class="fra-prefix">Fra: </div>'.wc_price($product->get_price()); 

     return $price;
}


// Add placeholders to checkout fields
add_filter( 'woocommerce_checkout_fields' , 'override_billing_checkout_fields', 20, 1 );
function override_billing_checkout_fields( $fields ) {
    $fields['billing']['billing_phone']['placeholder'] = 'Telefon';
    $fields['billing']['billing_email']['placeholder'] = 'Email';
    $fields['billing']['billing_company']['placeholder'] = 'Bedrift';
    $fields['shipping']['shipping_company']['placeholder'] = 'Bedrift';
    return $fields;
}

// Add custom placeholders to default checkout fields:
add_filter('woocommerce_default_address_fields', 'override_default_address_checkout_fields', 20, 1);
function override_default_address_checkout_fields( $address_fields ) {
    $address_fields['first_name']['placeholder'] = 'Fornavn';
    $address_fields['last_name']['placeholder'] = 'Efternavn';
    $address_fields['address_1']['placeholder'] = 'Adresse';
    $address_fields['state']['placeholder'] = 'Stat';
    $address_fields['postcode']['placeholder'] = 'Postnummer';
    $address_fields['city']['placeholder'] = 'By';
    return $address_fields;
}


/*
 * display custom variation selector
 */
add_filter('woocommerce_dropdown_variation_attribute_options_html', 'sefbo_variations_as_buttons', 10, 2);
function sefbo_variations_as_buttons($html, $args) {
    global $product;

    $custom_html = "";
    $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
        'options' => false,
        'attribute' => false,
        'product' => false,
        'selected' => false,
        'name' => '',
        'id' => '',
        'class' => '',
        'show_option_none' => __('Choose an option', 'woocommerce')
    ));
    $placeholder = wc_placeholder_img_src(array(50, 50));
    $options = $args['options'];
    $product = $args['product'];
    $attribute = $args['attribute'];
    $name = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
    $id = $args['id'] ? $args['id'] : sanitize_title($attribute);
    $class = $args['class'];
    $show_option_none = $args['show_option_none'] ? true : false;

    if (empty($options) && !empty($product) && !empty($attribute)) {
        $attributes = $product->get_variation_attributes();
        $options = $attributes[$attribute];
    }
    
    $custom_html = '<div class="variation-radios ' . esc_attr($class) . ' custom_var_wrap" name="' . esc_attr($name) . '" data-attribute_name="attribute_' . esc_attr(sanitize_title($attribute)) . '"' . '" data-show_option_none="' . ($show_option_none ? 'yes' : 'no') . '">';

    if (!empty($options)) {
        if ($product && taxonomy_exists($attribute)) {
            // Get terms if this is a taxonomy - ordered. We need the names too.
            $terms = wc_get_product_terms($product->get_id(), $attribute, array('fields' => 'all'));
            if ($terms) {
                foreach ($terms as $term) {
                    if (in_array($term->slug, $options)) {
                        $option_val = "<span class='option_val'>" . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)).'</span>';
                        $custom_html .= '<label for="custom_var_' . esc_attr($id) . '_' . esc_attr($term->slug) . '"><input type="radio" id="custom_var_' . esc_attr($id) . '_' . esc_attr($term->slug) . '" name="custom_var_' . esc_attr($id) . '" value="' . esc_attr($term->slug) . '" ' . checked(sanitize_title($args['selected']), $term->slug, false) . ' data-toggle="tooltip" title="'.esc_html(apply_filters('woocommerce_variation_option_name', $term->name)).'" data-placement="bottom" /><span>' . $option_val . '</span></label>';
                    }
                }
            }
        } else {
            //This is to show first variation selected by default if nothing is selected
//            if (!$args['selected']) {
//                $args['selected'] = current($options);
//            }
            foreach ($options as $option) {
                // This handles < 2.4.0 bw compatibility where text attributes were not sanitized.
                $selected = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                $custom_html .= '<label for="custom_var_' . esc_attr($id) . '_' . esc_attr($option) . '"><input id="custom_var_' . esc_attr($id) . '_' . esc_attr($option) . '" type="radio" name="custom_var_' . esc_attr($id) . '" value="' . esc_attr($option) . '" ' . $selected . '/><span>' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</span></label>';
            }
        }
    }

    $custom_html .= '</div>';
    $custom_html .= '<div class="custom-variation-name"><span class="empty"></span></div>';

    $class.= " d-none"; // added as drop down to be hidden always
    $html = '<select class="' . esc_attr($class) . '" name="' . esc_attr($name) . '" data-attribute_name="attribute_' . esc_attr(sanitize_title($attribute)) . '"' . '" data-show_option_none="' . ($show_option_none ? 'yes' : 'no') . '">';

    if ($show_option_none) {
        $html .= '<option value="">' . esc_html($args['show_option_none']) . '</option>';
    }

    if (!empty($options)) {
        if ($product && taxonomy_exists($attribute)) {
            // Get terms if this is a taxonomy - ordered. We need the names too.
            $terms = wc_get_product_terms($product->get_id(), $attribute, array('fields' => 'all'));
            if ($terms) {
                foreach ($terms as $term) {
                    if (in_array($term->slug, $options)) {
                        $html .= '<option value="' . esc_attr($term->slug) . '" ' . selected(sanitize_title($args['selected']), $term->slug, false) . '>' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</option>';
                    }
                }
            }
        } else {
            foreach ($options as $option) {
                // This handles < 2.4.0 bw compatibility where text attributes were not sanitized.
                $selected = sanitize_title($args['selected']) === $args['selected'] ? selected($args['selected'], sanitize_title($option), false) : selected($args['selected'], $option, false);
                $html .= '<option value="' . esc_attr($option) . '" ' . $selected . '>' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</option>';
            }
        }
    }

    $html .= '</select>';

    return $custom_html.$html;
}


//remove pagination, result count and standard filter dropdown from woocommerce:
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination',10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count',20);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering',30);


//Load more products starts

add_action('sefbo_load_more_waypoint', 'ajax_loader');

function ajax_loader() {
    $remove = false;
    global $wp_query;

    if ($wp_query->max_num_pages < 2) :
        $remove = true;
    endif;

    $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    ?>
    <input id="load-more-page" type="hidden" name="load-more-page" value="<?php echo $paged + 1; ?>"/>
    <?php if(is_tax()){?>
    <input id="current_term" type="hidden" name="current_term" value="<?php echo get_queried_object_id(); ?>"/>
    <?php }?>
    <div class="spinner loading-done" style="display: <?php echo $display; ?>">
       <div class="bounce1"></div>
       <div class="bounce2"></div>
       <div class="bounce3"></div>
    </div>
    <div id="load-more" <?php if (!$remove): ?>class="active"<?php endif; ?>>&nbsp;</div>
    <?php
}

add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);

function new_loop_shop_per_page($cols) {

    $cols = get_option('posts_per_page');
    return $cols;
}

add_action('wp_ajax_filterLoadPosts', 'filterLoadPosts');
add_action('wp_ajax_nopriv_filterLoadPosts', 'filterLoadPosts');

function filterLoadPosts() {
    global $post, $product, $woocommerce, $wp_query, $wpdb;
    $posts_per_page = get_option('posts_per_page');
    $paged = (int) $_POST['paged'];
    $orderby = $_POST['orderby'] ? $_POST['orderby'] : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
    $OrderKey = "";
    $product_cat = $_POST['product_cat'];
    $QueryOrderBy = "menu_order title";
    $meta_query = array();

    if ($orderby == 'price') {
        $QueryOrderBy = "meta_value_num ID";
        $OrderKey = "_price";
        $Order = "ASC";
    } elseif ($orderby == 'price-desc') {
        $QueryOrderBy = "meta_value_num ID";
        $OrderKey = "_price";
        $Order = "DESC";
    } elseif ($orderby == 'popularity') {
        $QueryOrderBy = "meta_value_num ID";
        $OrderKey = "total_sales";
        $Order = "DESC";
    } elseif ($orderby == 'rating') {
        $QueryOrderBy = "meta_value_num ID";
        $OrderKey = "_wc_average_rating";
        $Order = "DESC";
    } elseif ($orderby == 'date') {
        $QueryOrderBy = "date ID";
        //$OrderKey = "date";
        $Order = "DESC";
    } elseif ($orderby == 'menu_order') {
        $QueryOrderBy = "menu_order title";
        $Order = "ASC";
    }

    $args = array(
        'post_type' => 'product',
        'paged' => $paged,
        'posts_per_page' => $posts_per_page,
        'orderby' => $QueryOrderBy,
        'order' => $Order,
        'post_status' => 'publish',
    );
    if($product_cat){
        $args['tax_query'][] = array(
            'taxonomy' => 'product_cat',
            'field' => 'id',
            'terms' => array($product_cat),
        );
    }

    $wp_query = new WP_Query($args);
    $last = false;
    if ($wp_query->max_num_pages == $paged) {
        $last = true;
    }

    ob_start();
    if ($wp_query->have_posts()):
        while ($wp_query->have_posts()) : $wp_query->the_post();
            wc_get_template_part('content', 'product');
        endwhile;
    else:
        wc_get_template('loop/no-products-found.php');
    endif;
    wp_reset_query();

    $html = ob_get_clean();

    echo json_encode(array('last' => $last, 'html' => $html));

    die();
}

//Load more products ends


//remove cross sell from cart
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );