var $ = jQuery.noConflict();

//products load more start

jQuery(document).ready(function ($) {

   if(jQuery('#more_posts').length){
      var waypoint = new Waypoint({
         element: jQuery('#more_posts'),
         handler: function (direction) {
            if (direction == 'down') {
                  if(!jQuery('.center').hasClass("done"))
                  load_posts();
                  
            }
         },
         offset: 'bottom-in-view'
      });	
   }

   var ppp = 4; 
   var pageNumber = 1;

   function load_posts(){
      pageNumber++;
      post_type = jQuery('#more_posts').data('post_type');
      jQuery.ajax({
         type: "post",
         dataType: "json",
         url: adminajax.ajaxurl,
         data: {action: "more_post_ajax", ppp: ppp, pageNumber: pageNumber, post_type: post_type},
         success: function (response) {
               jQuery("#ajax-posts").append(response.html);
               if(response.last == true){
                  jQuery('.center').hide();
                  jQuery('.center').addClass("done");
               }
               else{
                  Waypoint.refreshAll();	
               }
         }
      });
      return false;
   }

   if (jQuery('#load-more').length){
      height = jQuery(window).height() + (jQuery('.product').height()) - 300;
      waypoint = new Waypoint({
         element: jQuery('#load-more'),
         handler: function (direction) {
            var load_more_page;
            var is_active = jQuery('#load-more').hasClass('active');

            if (direction == 'down' && is_active) {

               load_more_page = jQuery('#load-more-page').val();

               ajaxLoadPosts(load_more_page);
            }
         },
         offset: height
      });
   }
});


function getQueryVariable(variable) {
    var query = window.location.search.substring(1);
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
       var pair = vars[i].split("=");
       if (pair[0] == variable) {
          return pair[1];
       }
    }
    return(false);
 }


 function ajaxLoadPosts(pageNumber) {
 
    jQuery('body').addClass('ajax_loading');
    var orderby = getQueryVariable('orderby');
    if (!orderby) {
       orderby = '';
    }
    if (jQuery('#current_term').length) {
       product_cat = jQuery('#current_term').val();
    } else{
        product_cat = '';
    }
    jQuery.ajax({
       url: adminajax.ajax_url,
       type: 'POST',
       data: "action=filterLoadPosts&paged=" + pageNumber + '&orderby=' + orderby + '&product_cat=' + product_cat,
       dataType: 'json',
       success: function (data) {
          jQuery('body').removeClass('ajax_loading');
          jQuery('#load-more-page').val(parseInt(pageNumber) + 1);
          if (pageNumber == 1) {
             jQuery.when(jQuery("ul.products").html(data.html)).done(function () {
                Waypoint.refreshAll();
 
                jQuery(window).scroll();
             });
          } else {
             jQuery.when(jQuery("ul.products").append(data.html)).done(function () {
                Waypoint.refreshAll();
                jQuery(window).scroll();
             });
          }
          if (data.last != true) {
             jQuery('#load-more').addClass('active');
          } else {
             jQuery('#load-more').removeClass('active');
          }
       }
    });
 }


 $(document).ready(function(){
     
  jQuery(window).scroll(function() {
      
      if( jQuery('#post-results').length && (jQuery(window).scrollTop() >= ( parseInt(jQuery('#post-results').offset().top) + jQuery('#post-results').height() -  jQuery(window).height()))) {
          jQuery('input[name=post_load_more]').click().prop('disabled', true);
      }
      

      if( (jQuery('#dokumenter_results').length) && (jQuery(window).scrollTop() >= ( parseInt(jQuery('#dokumenter_results').offset().top) + jQuery('#dokumenter_results').height() - jQuery(window).height()))) {
          jQuery('input[name=load_more]').click().prop('disabled', true);
      }

  });
      
   $('input[name=load_more]').click(function (e) {

      if(!$(this).prop('disabled')) {
      var page_no = $('#page_no').val();
      page_no++;

      if(page_no <= parseInt($(this).data('total_pages'))) {
          $('#page_no').val(page_no);    
          product_ajax(e, true);
      } else {
          /*console.log('last page: stop!');*/
      }
      }
});

$('input[name=post_load_more]').click(function (e) {
  if(!$(this).prop('disabled')) {
    var page_no = $('#page_no').val();
    page_no++;

    if(page_no <= parseInt($(this).data('total_pages'))) {
      $('#page_no').val(page_no);    
      post_product_ajax(e, true);
    } else {
      /*console.log('last page: stop!');*/
    }
  }
});

if( $(".post-categories").length ) {
  var type = window.location.hash.substr(1);
  if(type) {
    $(".post-categories ul li a[data-id='"+type+"']").parent().addClass("active");
    $("input[data-id='" + type + "']").attr( 'checked', true );
  } else {
    $(".post-categories ul li a[data-id='0']").parent().addClass("active");
    $("input[data-id='0']").attr( 'checked', true );
  }

}

$(".post_tax_desktop").on("click", function(e){
      
    var id = $(this).find("a").data("id");
    $(".post_tax_desktop").removeClass("active");
    $(this).addClass("active");
    
    $(".post_tax_mobile").removeAttr('checked');
    $("input[data-id=" + id + "]").attr( 'checked', true );

    if(id != 0){
      window.history.replaceState('', '','#'+id);
    } else {
      var uri = window.location.toString();
      if (uri.indexOf("#") > 0) {
          var clean_uri = uri.substring(0, uri.indexOf("#"));
          window.history.replaceState({}, document.title, clean_uri);
      }
    }
    post_product_ajax(e, false);
    if(window.screen.width < 991){ 
    var target = jQuery('#post-results');
      if( target.length ) {
        jQuery('html, body').stop().animate({
          scrollTop: target.offset().top - 45
        }, 'slow');
      }
    }

    return false;
});  

});//close doc ready

function changeUrlParam (param, value) {
var currentURL = window.location.href+'&';

var uri_str = window.location.href;
var param_str = '';
var anchor_str = '';

var anchor_pos = uri_str.indexOf('#');
if(anchor_pos !== -1) {
  anchor_str = uri_str.substr(anchor_pos+1);
  uri_str = uri_str.substr(0, anchor_pos);
}

var param_pos = uri_str.indexOf('?');
var is_params = false;
if(param_pos !== -1) {
  param_str = uri_str.substr(param_pos+1);
  uri_str = uri_str.substr(0, param_pos);

  params = param_str.split('&');
  params_len = params.length;

  for(i=0; i < params_len; i++) {
    p = params[i];
    key = '';

    if(params[i].indexOf('=')===-1) {
      key = params[i];
    } else {
      p = params[i].split('=');
      key = p[0];
    }

    if(key==param) {
      params[i] = (value>0 || value!='')? key+'='+value: '';
      is_params = true;
    }
  }

  param_str = '';
  for(i=0; i < params_len; i++) {
    if(params[i]!='') {
      p = params[i].split('=');    
      param_str += '&'+p[0]+'='+p[1];
    }
  }

  if(param_str!='') {
    param_str = param_str.substr(1);
  }
}

if(!is_params && (value>0 || value!='')) {
  param_str += '&'+param+'='+value;
}

if(param_str!='') {
  uri_str += '?'+param_str;
}

if(anchor_str!='') {
  uri_str += '#'+anchor_str;
}


if (getURLParameter(param) !== null || value==''){
    try {
        window.history.replaceState('', '',uri_str);
    } catch (e) {
        //console.log(e);
    }
}else {
    var currURL = window.location.href;
    if (currURL.indexOf("?") !== -1){
        window.history.replaceState('', '', currentURL.slice(0, - 1) + '&' + param + '=' + encodeURIComponent(value));
    } else {
        window.history.replaceState('', '', currentURL.slice(0, - 1) + '?' + param + '=' + encodeURIComponent(value));
    }
}
}

function getURLParameter(name) {
return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [, ""])[1].replace(/\+/g, '%20')) || null;
}

function post_product_ajax(e, is_next_page) {

jQuery('#post_results').addClass('loader-active');

var data = 'action=posttriggerfilters';

/*find tax*/
var tax = jQuery(".post_tax_desktop.active a").data("id");
data += '&tax=' + tax;
//changeUrlParam("tax", tax);

var filter_params = ['page_no','type'];  

var page_no = 1;

for(var i=0; i < filter_params.length; i++) {
  var key = filter_params[i];

  if(!jQuery('#'+key).length) {
    continue; /* if the paramater does not exist on the page, do not use it  */
  }
  filter_params[i]
  var val = jQuery('#'+key).val();

  /* search filter selected -> restart search */
  if((key=='page_no' && !is_next_page)) {
    val = 1;
  }
  
  if(val!==false) { data += '&'+key+'=' + val; }
  //changeUrlParam(key, val);

  if(key=='page_no') {
    page_no = val;
  } else if(key=='last_page_no') {
    last_page_no = val;
  }
}

//console.log(data);

  jQuery.ajax({
  url: adminajax.ajax_url,
  type: 'POST',
  dataType: 'json',
  data: data,
  success: function (response) {
      if(is_next_page) { 
        jQuery('#post-results').append(response.html).removeClass('loader-active');
      } else {
        jQuery('#post-results').html(response.html).removeClass('loader-active');
      }

      jQuery('#last_page_no').val(page_no);
      if(!is_next_page){
          jQuery('#page_no').val(1);
      }
      jQuery('input[name=post_load_more]').data('total_pages', response.total_pages);

       if(response.html>0) {
         jQuery('input[name=post_load_more]').removeClass('d-none');
       } else {
         jQuery('input[name=post_load_more]').addClass('d-none');
       }

      
      jQuery('input[name=post_load_more]').prop('disabled', false);

      //load images here

    },
    error: function (err) {
      console.log('errors: '+err.responseText);
      jQuery('input[name=post_load_more]').prop('disabled', false);
    },
  })
}


