jQuery(document).ready(function () {

    function load_data(latitude  = '', longitude = ''){
        var filter_region = jQuery('#filter-regions').val();

        // console.log(typeof x);
        if(typeof x != 'undefined'){
            x.abort();
        } 
        x=jQuery.ajax({
            type: "POST",
            dataType: "json",
            url: adminajax.ajax_url,
            data: {action: "filter_slocator", filter_region: filter_region, lat:latitude, lng:longitude},
            success: function (response) {
                jQuery(".all-stores").html(response.message);
                initialize(jQuery(this),response.fulldata);
            }
        });

    }

    jQuery("#searchinput").keyup(function () {
        var formvalue = jQuery(this).val();
        handle_params_in_url();
        store_search(formvalue);
    });

    jQuery(document).on('change', 'select#filter-regions', function (event) {
        var formvalue = jQuery('#searchinput').val();
        handle_params_in_url();
        if(formvalue)
            store_search(formvalue);
        else 
            load_data();
    });

    function changeUrlParam(param, value) {
        var currentURL = window.location.href + '&';
        var uri_str = window.location.href;
        var param_str = '';
        var anchor_str = '';
    
        var anchor_pos = uri_str.indexOf('#');
        if (anchor_pos !== -1) {
            anchor_str = uri_str.substr(anchor_pos + 1);
            uri_str = uri_str.substr(0, anchor_pos);
        }
    
        var param_pos = uri_str.indexOf('?');
        var is_params = false;
        if (param_pos !== -1) {
            param_str = uri_str.substr(param_pos + 1);
            uri_str = uri_str.substr(0, param_pos);
    
            params = param_str.split('&');
            params_len = params.length;
    
            for (i = 0; i < params_len; i++) {
                p = params[i];
                key = '';
    
                if (params[i].indexOf('=') === -1) {
                    key = params[i];
                } else {
                    p = params[i].split('=');
                    key = p[0];
                }
    
                if (key == param) {
                    params[i] = (value > 0 || value != '') ? key + '=' + value : '';
                    is_params = true;
                }
            }
    
            param_str = '';
            for (i = 0; i < params_len; i++) {
                if (params[i] != '') {
                    p = params[i].split('=');
                    param_str += '&' + p[0] + '=' + p[1];
                }
            }
    
            if (param_str != '') {
                param_str = param_str.substr(1);
            }
        }
    
        if (!is_params && (value > 0 || value != '')) {
            param_str += '&' + param + '=' + value;
        }
    
        if (param_str != '') {
            uri_str += '?' + param_str;
        }
    
        if (anchor_str != '') {
            uri_str += '#' + anchor_str;
        }
    
        if (getURLParameter(param) !== null || value == '') {
            try {
                window.history.replaceState('', '', uri_str);
            } catch (e) {
                console.log(e);
            }
        } else {
            var currURL = window.location.href;
            if (currURL.indexOf("?") !== -1) {
                window.history.replaceState('', '', currentURL.slice(0, -1) + '&' + param + '=' + encodeURIComponent(value));
            } else {
                window.history.replaceState('', '', currentURL.slice(0, -1) + '?' + param + '=' + encodeURIComponent(value));
            }
        }
    }
    
    function getURLParameter(name) {
        return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [, ""])[1].replace(/\+/g, '%20')) || null;
    }
    
    function handle_params_in_url(){
        changeUrlParam ("regions", jQuery('#filter-regions').val());
        changeUrlParam ("searchinput", jQuery("#searchinput").val());
    }

    function store_search(address) {
        if (address.length > 2) {
            var geocoder = new google.maps.Geocoder();
            geocoder.geocode({'address': address}, function (results, status) {
                console.log("results:",results)
                if (status == google.maps.GeocoderStatus.OK) {
                    var latLng = results[0].geometry.location;
                    var lat = latLng.lat();
                    var lng = latLng.lng();
                    load_data(lat, lng);
                    console.log("latlng:",lat, lng)
                }
            });
        }
        else if(!address){
            load_data();
        }
    }

});

