<?php 
/*
* Template name: Interndokumenter
*/

if(!is_user_logged_in()): 
    header( "location: " . get_permalink ( get_option ( 'woocommerce_myaccount_page_id' ) ) );  
    return;
endif;

get_header();

?>

    <div class="container-fluid fullwidth-grid">
        <div class="row">

            <div class="col-xl-3 col-lg-12 col-12">

                <div class="buttons-grid">
                
                    <a href="<?php echo get_permalink(get_page_id_by_template('page-internnytt.php')[0]); ?>" class="sefbo-btn green">Internnyheter</a>

                    <a href="<?php the_permalink(); ?>" class="sefbo-btn green active">Dokumenter</a>

                    <?php 
                    //get all category terms
                    $tax_terms = get_terms( array(
                        'taxonomy' => 'dokument_kategorier',
                        'hide_empty' => true,
                        'parent' => 0,
                        'include' => getTermsFromPosts(),
                    ) );
                    //user first
                    $page_no = ( isset($_GET['page_no']) ) ? $_GET['page_no'] : 1;
                    $filter_params = search_get_filter_params('GET');

                    extract($filter_params);
                    $current_url = get_permalink();
                    ?>
                    <div class="post-categories">
                        <ul>
                            <?php
                            if($tax_terms){
                                foreach($tax_terms as $term){
                                    ?>
                                    <li class="post_tax_desktop post_tax">
                                        <a class="category-btn" href="<?php echo $current_url; ?>#<?php echo $term->slug?>" data-id="<?php echo $term->slug?>"><?php echo $term->name ?></a>
                                    </li>
                                <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>

                </div>

            </div>
            
            <div class="col-xl-9 col-lg-12 col-12">
                <div class="intranett-header">
                    <h1><?php the_title(); ?></h1>
                    <?php the_content(); ?>
                </div>



                    <div class="documents" id="post-results">
                        <?php
                        $the_query = get_archive_query($page_no, 'dokumenter', $filter_params, false);
                        $results = callposthtmldata($the_query,$page_no,false);

                        if($tax_terms){

                            foreach($tax_terms as $term){
                                                                                              
                                $user = wp_get_current_user(); 

                                $roles = $user->roles[0];

                                if ( in_array( 'daglig_leder', (array) $user->roles ) || in_array( 'shop_manager', (array) $user->roles ) ){
                                    $args =  array(
                                        'post_type' => 'dokumenter',
                                        'posts_per_page' => -1,
                                        'tax_query' => array(
                                            array (
                                                'taxonomy' => 'dokument_kategorier',
                                                'field' => 'term_id',
                                                'terms' => $term->term_id,
                                            )
                                        ),
                                        'meta_query' => array(
                                            'relation' => 'OR',
                                                array(
                                                    'key' => 'tilgjengelig_kun_for_dl',
                                                    'value' => 1,
                                                    'compare' => 'LIKE'
                                                ),
                                                array(
                                                    'key' => 'tilgjengelig_kun_for_dl',
                                                    'value' => 0,
                                                    'compare' => '='
                                                ),
                                                array(
                                                    'key' => 'tilgjengelig_kun_for_dl',
                                                    'compare' => 'NOT EXISTS'
                                                ),
                                        ),
                                    );
                                }
                                else{
                                    $args =  array(
                                        'post_type' => 'dokumenter',
                                        'posts_per_page' => -1,
                                        'tax_query' => array(
                                            array (
                                                'taxonomy' => 'dokument_kategorier',
                                                'field' => 'term_id',
                                                'terms' => $term->term_id,
                                            )
                                        ),
                                        'meta_query' => array(
                                            'relation' => 'OR',
                                                array(
                                                    'key' => 'tilgjengelig_kun_for_dl',
                                                    'value' => 0,
                                                    'compare' => 'LIKE'
                                                ),
                                                array(
                                                    'key' => 'tilgjengelig_kun_for_dl',
                                                    'compare' => 'NOT EXISTS'
                                                ),
                                        ),
                                    );
                                }
                               

                                $wp_query = new WP_Query( $args );

                                if($wp_query->have_posts()){
                                    ?> 
                                    <h2><?php echo $term->name ?></h2> 
                                    <div class="row">
                                    <?php 
                                
                                    
                                    while ( $wp_query->have_posts() ) : $wp_query->the_post();
                                        ?>
                                        <?php if(get_field('fil')): ?>
                                            <div class="col-xl-4 col-lg-6 col-12 document">
                                                <?php $fil = get_field('fil'); 
                                                    $filetype = substr($fil['filename'] , strpos($fil['filename'] , ".") + 1);
                                                ?>
                                                <a download href="<?php echo get_field('fil')['url']; ?>"><?php echo $fil['title']." (".$filetype.")"; ?></a>
                                            </div>
                                        <?php endif; ?>
                            
                                        <?php 
                            
                                    endwhile; wp_reset_postdata();
                        
                                    ?>
                                    </div>
                                <?php
                                }
                    
                            }
                        }

                        ?>
                    </div>


                <div class="text-center d-none">
                    <input type="button" class="btn site-btn <?php if($results["total_pages"] <= 1) echo 'd-none'; ?>" name="post_load_more" data-total_pages="<?php echo $results["total_pages"]; ?>" value="Load More">
                </div>

                <input type="hidden" name="page_no" id="page_no" value="<?php echo $page_no; ?>">
                <input type="hidden" name="last_page_no" id="last_page_no" value="<?php echo $page_no; ?>">
                <input type="hidden" name="type" id="type" value="dokumenter">

            </div>

        </div>
    </div>



<?php get_footer(); ?>
