<?php 
/*
* Template name: Internnytt
*/

if(!is_user_logged_in()): 
    header( "location: " . get_permalink ( get_option ( 'woocommerce_myaccount_page_id' ) ) );  
    return;
endif;

get_header();

?>

    <div class="container-fluid fullwidth-grid">
        <div class="row">

            <div class="col-xl-3 col-lg-12 col-12">

                <div class="buttons-grid">
                
                    <a href="<?php the_permalink(); ?>" class="sefbo-btn green active">Internnyheter</a>

                    <a href="<?php echo get_permalink(get_page_id_by_template('page-interndokumenter.php')[0]); ?>" class="sefbo-btn green">Dokumenter</a>

                </div>

            </div>
            
            <div class="col-xl-9 col-lg-12 col-12">
                <div class="intranett-header">
                    <h1><?php the_title(); ?></h1>
                    <?php the_content(); ?>
                </div>


                <div class="row nyheter">
                
                <?php 


                $args = array(
                    'post_type' => 'internnyheter',
                    'posts_per_page' => -1,
                );

                $user = wp_get_current_user(); 

                $roles = $user->roles[0];
            
                if ( in_array( 'daglig_leder', (array) $user->roles ) || in_array( 'shop_manager', (array) $user->roles ) ){
                    $meta_query_args[] = array(
                        'relation' => 'OR',
                        array(
                            'key' => 'tilgjengelig_kun_for_dl',
                            'value' => 1,
                            'compare' => 'LIKE'
                        ),
                        array(
                            'key' => 'tilgjengelig_kun_for_dl',
                            'value' => 0,
                            'compare' => '='
                        ),
                        array(
                            'key' => 'tilgjengelig_kun_for_dl',
                            'compare' => 'NOT EXISTS'
                        ),
                    );
                }else{
                    $meta_query_args[] = array(
                    'relation' => 'OR',
                        array(
                            'key' => 'tilgjengelig_kun_for_dl',
                            'value' => 0,
                            'compare' => 'LIKE'
                        ),
                        array(
                            'key' => 'tilgjengelig_kun_for_dl',
                            'compare' => 'NOT EXISTS'
                        ),
                    );
                }
            
                $args['meta_query'] = $meta_query_args;

                $wp_query = new WP_Query($args);

                while ( $wp_query->have_posts() ) : $wp_query->the_post();
                $nyhetFeaturedImage = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' )[0]; 
                ?>
                    <div class="col-xl-4 col-lg-6 col-12 nyhet">
                        <a href="<?php echo get_the_permalink($post->ID); ?>">
                            <div class="nyhet-inner">
                                <div class="image" style="background-image:url('<?php echo $nyhetFeaturedImage; ?>')"></div>
                                <h3><?php echo get_the_title($post->ID); ?></h3>
                                <?php 
                                if(has_excerpt($post->ID)): 
                                    echo "<p>".get_the_excerpt($post->ID)."</p>";
                                else:
                                    echo "<p>".wp_trim_words(get_the_content($post->ID), 25)."</p>";
                                endif;
                                ?>
                                <span class="read-more sefbo-btn green">Les mer</span>
                            </div>
                        </a>
                    </div>
        
                    <?php 
        
                endwhile;

                wp_reset_postdata();
                
                ?>

                </div>

            </div>

        </div>
    </div>



<?php get_footer(); ?>
