<?php 

/*
* Template name: Tjenestekategorier
*/

get_header(); 


$terms = get_terms( array(
    'taxonomy' => 'kategorier',
    'hide_empty' => true,
    'orderby' => 'menu_order',
    'order' => 'ASC',
) ); 

?>
    <div class="container-fluid tjenester">

    <div class="row">
        <div class="col-sm-12">
            <?php
            if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<p class="archive-breadcrumbs breadcrumbs" id="breadcrumbs">','</p>' );
            }
            ?>
        </div>
    </div>


        <div class="row">

            <div class="col-lg-12 title-column">
                <div class="title-column-inner archive after-breadcrumbs">
                    <h1><?php echo the_title(); ?></h1>
                    <h2><?php the_field('undertittel'); ?></h2>
                    <div class="description">
                        <?php echo get_the_content(); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row tjenesterow">
            <?php
                
                foreach ($terms as $term):

                $bilde = get_field('tjenestekategori_bilde', $term)['url'];
                $tittel = $term->name;
                $link = get_term_link($term->term_id,'kategorier');
                ?>
                    <div class="col-xl-3 col-md-4 col-sm-6 col-6 tjeneste">
                        <a href="<?php echo $link ?>">
                            <div class="tjeneste-inner" style="background-image:url('<?php echo $bilde; ?>')">
                                
                            </div>

                            <h3><?php echo $tittel; ?></h3>
                        </a>
                    </div>

                <?php 

                endforeach;
                wp_reset_postdata();

            ?>
        </div>
    </div>
    <?php



get_footer();