<?php 

/*
* Template name: Tjenestekategorier
*/

get_header(); 


$terms = get_terms( array(
    'taxonomy' => 'kategorier',
    'hide_empty' => true,
    'orderby' => 'menu_order',
    'order' => 'ASC',
) ); 

?>
    <?php get_template_part('template-parts/content', 'banner-tjeneste-page'); ?>
    <div class="container-fluid tjenester">
        <div class="row">

            <div class="col-lg-12 title-column">
                <div class="title-column-inner archive after-breadcrumbs">
                    <h1><?php echo the_title(); ?></h1>
                    <h2><?php the_field('undertittel'); ?></h2>
                    <div class="description">
                        <?php echo get_the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
        <a class="show-taxes mobil single-tjeneste" href="javascript:void(0);">Se tjenester</a>
        <ul class="tax-list single-tjeneste">
            <?php
                
            foreach ($terms as $term):

                $bilde = get_field('tjenestekategori_bilde', $term)['url'];
                $tittel = $term->name;
                $link = get_term_link($term->term_id,'kategorier');
                ?>
                    <li>
                        <a href="<?php echo $link ?>">
                            <?php echo $tittel; ?>
                        </a>
                    </li>

                <?php 

            endforeach;
            wp_reset_postdata();

            ?>
        </ul>

        <?php
            if( have_rows('utvalgte_tjenester') ):        

                ?>
                <div class="post_grid">
                    <?php
                    while( have_rows('utvalgte_tjenester') ) : the_row();

                        $odd = "";
                        if( get_row_index() % 2 != 0 ) {
                            $odd = "flex-row-reverse";
                        }

                        $featuredImage = get_sub_field('bilde')['url'];
                        $tittel = get_sub_field('tittel');
                        $tekst = get_sub_field('tekst');
                        $link = get_sub_field('link');
                        ?>
                        <a href="<?php echo $link ?>" class="post_row d-flex <?php echo $odd; ?>">
                            <div class="col_1">
                                <?php
                                if( $featuredImage ) {
                                    ?>
                                    <div class="img_container">
                                        <img src="<?php echo $featuredImage; ?>" alt="<?php echo $tittel; ?>">
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                            <div class="col_2">
                                <div class="info">
                                    <h2 class="title">
                                        <?php echo $tittel; ?>
                                    </h2>
                                    <div class="exercpt">
                                        <?php echo $tekst; ?>
                                    </div>
                                    <div class="read_more">
                                        Les mer
                                    </div>
                                </div>
                            </div>
                        </a>
                        <?php
                    endwhile; wp_reset_postdata();
                    ?>
                </div>
                <?php
            else:

                $velg_hoveddtjenester = get_field("velg_hoveddtjenester");

                // echo "<pre>";
                // print_r($velg_hoveddtjenester);
                // echo "</pre>";
                if( !empty($velg_hoveddtjenester) ) {
                    ?>
                    <div class="post_grid">
                        <?php
                        foreach ($velg_hoveddtjenester as $key => $item) {
                            $odd = "";
                            if( $key % 2 != 0 ) {
                                $odd = "flex-row-reverse";
                            }

                            $featuredImage = wp_get_attachment_image_src( get_post_thumbnail_id($item->ID), 'full' )[0];
                            ?>
                            <a href="<?php echo get_permalink( $item->ID ); ?>" class="post_row d-flex <?php echo $odd; ?>">
                                <div class="col_1">
                                    <?php
                                    if( $featuredImage ) {
                                        ?>
                                        <div class="img_container">
                                            <img src="<?php echo $featuredImage; ?>" alt="<?php echo $item->post_title; ?>">
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <div class="col_2">
                                    <div class="info">
                                        <h2 class="title">
                                            <?php echo $item->post_title; ?>
                                        </h2>
                                        <div class="exercpt">
                                            <?php echo $item->post_excerpt; ?>
                                        </div>
                                        <div class="read_more">
                                            Les Mer
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <?php
                        }
                        ?>
                    </div>
                <?php
            }
            endif;
        ?>
    </div>
    <?php



get_footer();