<?php 

$has_posts = 1;
$has_products = 1;
get_header(); 

?>

<div class="container-fluid search-page-title">
    <div class="row">
        <div class="col-lg-12">
            <div class="title-column-inner">
                <h1>Søk</h1>
                <div class="anchors">
                    <a class="scroll-to products-anchor" href="#produkter">Se produkter</a>
                    <a class="scroll-to posts-anchor" href="#nyheter">Se innlegg</a>
                </div>
                <form role="search" method="get" id="searchform" class="searchform" action="/">
                    <div class="field-wrap">
                        <label class="screen-reader-text" for="s">Søk etter:</label>
                        <span>Du søkte etter: </span>
                        <button type="submit" id="searchsubmit"> <img src="<?php echo get_stylesheet_directory_uri().'/images/search.svg'; ?>" alt="Sefbo search icon"> </button>
                        <input placeholder="" type="text" value="<?php echo get_search_query(); ?>" name="s" id="search">
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>


<?php
$search_query = get_search_query();
$excluded = array(9,10,8,11,89, get_page_id_by_template('page-interndokumenter.php')[0], get_page_id_by_template('page-internnytt.php')[0],get_page_id_by_template('page-login.php')[0]);
$query_argsuments1 = array( 
    'post__not_in' => $excluded,
    'post_type' => ['post','page','tjenester'],
    'posts_per_page' => -1,
    's' => $search_query
);

$wp_postpage = new WP_Query( $query_argsuments1 );

if($wp_postpage->have_posts()):
    
    ?> 

    <div class="container-fluid nyheter" id="nyheter">
        <div class="row">
            <div class="col-lg-12 title-column">
                <div class="title-column-inner">
                    <span>Tjenester, Sider og innlegg</span>
                </div>
            </div>
        </div>

        <div class="row"> 
        <?php

        while ( $wp_postpage->have_posts() ) : $wp_postpage->the_post();
        $has_posts++;

        $bilde = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' )[0];
            ?>
            <div class="col-lg-4 nyhet">
                <a href="<?php echo get_the_permalink($post->ID); ?>">
                    <div class="nyhet-inner">
                        <div class="image" style="background-image:url('<?php echo $bilde; ?>')"></div>
                        <h3><?php echo get_the_title($post->ID); ?></h3>
                        <?php 
                        if(has_excerpt($post->ID)): 
                            echo "<p>".wp_trim_words(get_the_excerpt($post->ID), 25)."</p>";
                        else:
                            echo "<p>".wp_trim_words(get_the_content($post->ID), 25)."</p>";
                        endif;
                        ?>
                        <span class="read-more">Les mer</span>
                    </div>
                </a>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>
        </div>
    </div>
    <?php
endif;  

?>

<?php

$query_argsuments = array( 
    'post_type' => 'product',
    'posts_per_page' => -1,
    's' => $search_query
);

global $product;

$wp_products = new WP_Query( $query_argsuments );


if($wp_products->have_posts()){
    
    ?>
        <div class="container-fluid woocommerce" id="produkter">

            <div class="row">
                <div class="col-lg-12 title-column">
                    <div class="title-column-inner">
                        <span>Produkter</span>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 products-wrap support-content">    

                    <?php

                    do_action( 'woocommerce_before_shop_loop' );

                    woocommerce_product_loop_start();

                    while ( $wp_products-> have_posts() ) {
                        $wp_products ->the_post();
                        $has_products++;
            
                        /**
                         * Hook: woocommerce_shop_loop.
                        */
                        do_action( 'woocommerce_shop_loop' );
            
                        wc_get_template_part( 'content', 'product' );
                    }
                    woocommerce_product_loop_end();

                    do_action( 'woocommerce_after_shop_loop' );


                    wp_reset_postdata();
                    ?>
                    </div>
                </div>
            </div>
    <?php 
 }
    
    ?>


<?php get_footer(); ?>