<!--Standard page template-->
<?php 

get_header(); 


    while ( have_posts() ) : the_post();
    
        
    $over_velg_tjenester = get_field('velg_relevante_tjeneste');
    $over_tittel = get_field('tittel_relevant');
    $over_undertittel = get_field('undertittel_relevant');


    ?> 
    

    <?php get_template_part('template-parts/content', 'banner-standard'); ?>

        <div class="container-fluid content-width">

            <div class="taxes-wrapper">
                <div class="row">
                    <div class="col-lg-12 mobile-grid">
                    <?php

                    $args = array(
                        'post_type'      => 'tjenester',
                        'posts_per_page' => -1,
                        'post_parent'    => get_the_ID(),
                        'order'          => 'ASC',
                        'orderby'        => 'menu_order'
                    );


                    $parent = new WP_Query( $args );

                    if ( $parent->have_posts() ) :  
                        echo '<a class="show-taxes mobil single-tjeneste" href="javascript:void(0);">Se tjenester</a>';
                        echo "<ul class='tax-list single-tjeneste'>";
                            while ( $parent->have_posts() ) : $parent->the_post();
                                echo "<li><a href='".get_permalink()."'>".get_the_title()."</a></li>";
                            endwhile; wp_reset_postdata();
                        echo "</ul>";
                    endif;

                    ?>

                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-7 support-content mobile-grid">    
                    <div class="title-block">
                        <h1><?php the_title(); ?></h1>
                        <h2><?php the_field('undertittel'); ?></h2>
                        <?php if(has_excerpt()): the_excerpt(); endif; ?>
                    </div>
                    <?php the_content(); ?>
                </div>

                <div class="col-lg-5">

                    <?php  if( $over_velg_tjenester ): ?>
                    <div class="tjenester mobil" style="margin-bottom:65px;">

                        <div class="row">

                            <div class="col-lg-12 title-column">
                                <div class="title-column-inner">
                                    <span><?php echo $over_tittel; ?></span>
                                    <h2><?php echo $over_undertittel; ?></h2>
                                </div>
                            </div>
                        </div>

                        <div class="row tjenesterow">
                            <?php 
                               
                                    foreach( $over_velg_tjenester as $tjeneste ):
                                        setup_postdata($tjeneste);
                                        $bilde = wp_get_attachment_image_src( get_post_thumbnail_id($tjeneste->ID), 'full' )[0];
                                        $tittel = get_the_title($tjeneste->ID);
                                        $link = get_the_permalink($tjeneste->ID);
                                        ?>
                                            <div class="col-xl-3 col-md-4 col-sm-6 col-6 tjeneste">
                                                <a href="<?php echo $link ?>">
                                                    <div class="tjeneste-inner" style="background-image:url('<?php echo $bilde; ?>')"></div>
                                                    <h3><?php echo $tittel; ?></h3>
                                                </a>
                                            </div>
                                        <?php
                                    endforeach;
                               
                            ?>
                        </div>

                    </div>
                    <?php  endif; ?>

                    <div class="sidebar" id="contact">
                        <div class="contact-info-wrap">
                            <ul>
                                <li class="address"><?php the_field('adresse','option') ?></li>
                                <li class="phone"><a href="tel:<?php the_field('telefon','option') ?>"><?php the_field('telefon','option') ?></a></li>
                                <li class="email"><a href="mailto:<?php the_field('e-post','option') ?>"><?php the_field('e-post','option') ?></a></li>
                            </ul>
                        </div>

                        <div class="form-wrap">
                        <?php hent_skjema(get_field('kontaktskjema','option')); ?>
                        </div>

                        <div class="ansatte">
                            <?php 
                            if( have_rows('ansatt','option') ):
                                while( have_rows('ansatt','option') ) : the_row();
                                    $bilde = get_sub_field('bilde');
                                    $navn = get_sub_field('navn__tittel');
                                    $stilling = get_sub_field('stilling');
                                    $telefon = get_sub_field('telefon');
                                    $epost = get_sub_field('e-post');

                                ?>
                                    <div class="rad">
                                        <div class="ansatt-column-1">
                                            <div class="ansatt-image" style="background-image:url('<?php echo $bilde['url']; ?>')"></div>
                                        </div>

                                        <div class="ansatt-column-2">
                                            <div class="column-inner">
                                                <h2><?php echo $navn; ?></h2>
                                                <span><?php echo $stilling; ?></span>
                                                <a href="tel:<?php echo $telefon; ?>"><?php echo $telefon; ?></a>
                                                <a href="mailto:<?php echo $epost; ?>"><?php echo $epost; ?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php 

                                endwhile;
                                
                            endif;

                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>

       

            <div class="container-fluid tjenester desktop">

                <div class="row">

                    <div class="col-lg-12 title-column">
                        <div class="title-column-inner">
                            <span><?php echo $over_tittel; ?></span>
                            <h2><?php echo $over_undertittel; ?></h2>
                        </div>
                    </div>
                </div>

                <div class="row tjenesterow">
                    <?php 
                        if( $over_velg_tjenester ):
                            foreach( $over_velg_tjenester as $tjeneste ):
                                setup_postdata($tjeneste);
                                $bilde = wp_get_attachment_image_src( get_post_thumbnail_id($tjeneste->ID), 'full' )[0];
                                $tittel = get_the_title($tjeneste->ID);
                                $link = get_the_permalink($tjeneste->ID);
                                ?>
                                    <div class="col-xl-3 col-md-4 col-sm-6 col-6 tjeneste">
                                        <a href="<?php echo $link ?>">
                                            <div class="tjeneste-inner" style="background-image:url('<?php echo $bilde; ?>')"></div>
                                            <h3><?php echo $tittel; ?></h3>
                                        </a>
                                    </div>
                                <?php
                            endforeach;
                        endif;
                    ?>
                </div>

            </div>

    <?php endwhile; ?>

<?php wp_reset_postdata(); ?>

<?php get_footer(); ?>
