<!--Standard page template-->
<?php 

get_header(); 



    while ( have_posts() ) : the_post();?> 

    <?php get_template_part('template-parts/content', 'banner-standard'); ?>

        <div class="container-fluid content-width">
            <div class="row">
                <div class="col-lg-7 support-content mobile-grid">    
                    <div class="title-block">
                        <h1><?php the_title(); ?></h1>
                        <h2><?php the_field('undertittel'); ?></h2>
                        <?php if(has_excerpt()): the_excerpt(); endif; ?>
                    </div>
                    <?php the_content(); ?>
                </div>

                <div class="col-lg-5">
                    <div class="sidebar" id="contact">
                        <div class="contact-info-wrap">
                            <ul>
                                <li class="address"><?php the_field('adresse','option') ?></li>
                                <li class="phone">
                                    <?php if(get_field('telefon', 'option')): ?><p><?php the_field('avdeling','option'); ?>: <a href="tel:<?php the_field('telefon','option') ?>"><?php the_field('telefon','option') ?></a></p> <?php endif; ?>
                                    <?php if(get_field('telefon_2', 'option')): ?><p><?php the_field('avdeling_2', 'option'); ?>: <a href="tel:<?php the_field('telefon_2','option') ?>"><?php the_field('telefon_2','option') ?></a></p><?php endif; ?>
                                </li>
                                <li class="email"><a href="mailto:<?php the_field('e-post','option') ?>"><?php the_field('e-post','option') ?></a></li>
                            </ul>
                        </div>

                        <div class="form-wrap">
                        <?php hent_skjema(get_field('kontaktskjema','option')); ?>
                        </div>

                        <div class="ansatte">
                            <?php 
                            if( have_rows('ansatt','option') ):
                                while( have_rows('ansatt','option') ) : the_row();
                                    $bilde = get_sub_field('bilde');
                                    $navn = get_sub_field('navn__tittel');
                                    $stilling = get_sub_field('stilling');
                                    $telefon = get_sub_field('telefon');
                                    $epost = get_sub_field('e-post');

                                ?>
                                    <div class="rad">
                                        <div class="ansatt-column-1">
                                            <div class="ansatt-image" style="background-image:url('<?php echo $bilde['url']; ?>')"></div>
                                        </div>

                                        <div class="ansatt-column-2">
                                            <div class="column-inner">
                                                <h2><?php echo $navn; ?></h2>
                                                <span><?php echo $stilling; ?></span>
                                                <a href="tel:<?php echo $telefon; ?>"><?php echo $telefon; ?></a>
                                                <a href="mailto:<?php echo $epost; ?>"><?php echo $epost; ?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php 

                                endwhile;
                                wp_reset_postdata();
                            endif;

                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>

    <?php endwhile; ?>

<?php wp_reset_postdata(); ?>

<?php get_footer(); ?>
