<?php

$featuredImage = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' )[0]; 
$tittel_banner = get_field('tittel_banner');
$tekst_banner = get_field('tekst_banner');
$link_banner = get_field('link_banner');

if(is_tax() || is_shop()){
    if(is_tax()):
        $tax = get_queried_object();
        $tax_values = 'product_cat_' . $tax->term_id; 
        $featuredImage = get_field('bilde',$tax_values)['url'];
        $tittel_banner = get_field('tittel_banner',$tax_values);
        $tekst_banner = get_field('tekst_banner',$tax_values);
        $link_banner = get_field('link_banner',$tax_values);
    endif;

    if(!$featuredImage) $featuredImage = get_field('produktkategoribilde','option')['url'];
    if(is_shop()): 
        $featuredImage = get_field('produktkategoribilde','option')['url']; 
        $tekst_banner = "Dette er en samling av alle produktene vi selger her på Sefbo.no";
        $link_banner['title'] = 'Se utvalgte produkter';
        $link_banner['url'] = '/nettbutikk/';
    endif;
}

if(is_page_template('page-nettbutikkforside.php')){
    if(have_rows('nettbutikk-slider')){ ?>
        <div class="banner-wrapper">
            <div class="woocommerce-banner container-fluid">
                <div class="row">
                    <div class="col-lg-12 no-pad">
                        <div class="banner-image-outer">

                            <?php while ( have_rows( 'nettbutikk-slider' ) ) : the_row(); ?>

                                <div class="banner-image-inner" style="background-image:url('<?php echo get_sub_field('bilde')['url']; ?>')">
                            
                                    <div class="banner-text-outer">
                                        <div class="banner-text-inner">
                                            <h1><?php echo get_sub_field('tittel_banner'); ?></h1>
                                            <p><?php echo get_sub_field('tekst_banner'); ?></p>
                                            <?php if(get_sub_field('link_banner')): ?>
                                            <a class="sefbo-btn auto-width green" href="<?php echo get_sub_field('link_banner')['url']; ?>"><?php echo get_sub_field('link_banner')['title']; ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
            
                                </div>

                            <?php endwhile; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            jQuery('.banner-image-outer').slick({
                dots: true,
                arrows:false,
                infinite: true,
                speed: 1000,
                autoplaySpeed: 3000,
                autoplay: true,
                fade: true,
                cssEase: 'ease-in-out'
            });
        </script>

    <?php }
}
else{
    
?>

<div class="banner-wrapper">
    <div class="woocommerce-banner container-fluid <?php if(!$featuredImage) echo "no-image"; ?>">
        <div class="row">
            <div class="col-lg-12 no-pad">
                <div class="banner-image-outer">
                    <div class="banner-image-inner" style="background-image:url('<?php echo $featuredImage; ?>')">
                    
                        <div class="banner-text-outer">
                            <div class="banner-text-inner">

                                <?php if($tittel_banner): ?>
                                <h1><?php echo $tittel_banner; ?></h1>
                                <?php else: ?>
                                <h1><?php woocommerce_page_title(); ?></h1>
                                <?php endif; ?>

                                <?php if($tekst_banner): ?>
                                <p><?php echo $tekst_banner; ?></p>
                                <?php else: ?>
                                <?php do_action( 'woocommerce_archive_description' ); ?>
                                <?php endif; ?>

                                <?php if($link_banner): ?>
                                <a class="sefbo-btn auto-width green" href="<?php echo $link_banner['url']; ?>"><?php echo $link_banner['title']; ?></a>
                                <?php endif; ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php } ?>

<div class="container-fluid content-width desktop">
    <div class="row">
        <div class="col-sm-12">
        <?php 
            if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<p class="breadcrumbs" id="breadcrumbs">','</p>' );
            }
        ?>
        </div>
    </div>
</div>

<?php get_template_part('template-parts/content', 'tax-row'); ?>