<?php
   $tittel = get_field('tittel');
   $undertittel = get_field('undertittel');
   $velg_nyheter = get_field('velg_nyheter');
   
?>

<div class="container-fluid nyheter">

    <div class="row">

        <div class="col-lg-12 title-column">
            <div class="title-column-inner">
                <span><?php echo $tittel; ?></span>
                <h2><?php echo $undertittel; ?></h2>
            </div>
        </div>
    </div>

    <div class="row">
        <?php 
            if( $velg_nyheter ):
                foreach ($velg_nyheter as $nyhet): 
                    setup_postdata($nyhet);
                    $nyhetFeaturedImage = wp_get_attachment_image_src( get_post_thumbnail_id($nyhet->ID), 'full' )[0]; 
                    ?>
                        <div class="col-lg-4 nyhet">
                            <a href="<?php echo get_the_permalink($nyhet->ID); ?>">
                                <div class="nyhet-inner">
                                    <div class="image" style="background-image:url('<?php echo $nyhetFeaturedImage; ?>')"></div>
                                    <h3><?php echo get_the_title($nyhet->ID); ?></h3>
                                    <?php 
                                    if(has_excerpt($nyhet->ID)): 
                                        echo "<p>".get_the_excerpt($nyhet->ID)."</p>";
                                    else:
                                        echo "<p>".wp_trim_words(get_the_content($nyhet->ID), 25)."</p>";
                                    endif;
                                    ?>
                                    <span class="read-more sefbo-btn green">Les mer</span>
                                </div>
                            </a>
                        </div>
                    <?php
                endforeach;
            endif;
        ?>
    </div>

</div>