<?php
   $tittel = get_field('tittel','option');
   $undertittel = get_field('undertittel_selskapsseksjon','option');
   $velg_bedrifter = get_field('velg_bedrifter');   

   $args = array(
    'post_type' => 'selskaper',
    'posts_per_page' => -1,
    'post_status' => 'publish',
    'post__in' => $velg_bedrifter,
    'orderby' => 'post__in',
   );

   $wp_query = new WP_Query($args);
   
?>

<div class="container-fluid selskaper">

    <div class="row">

        <div class="col-lg-12 title-column">
            <div class="title-column-inner">
                <span><?php echo $tittel; ?></span>
                <h2><?php echo $undertittel; ?></h2>
            </div>
        </div>
    </div>

    <div class="slider">   
        <?php 
            if($wp_query->have_posts()):
                                    
                while ($wp_query->have_posts()) : $wp_query->the_post(); 
                    $permalink = get_the_permalink();
                    if(get_field('nettside')): $permalink = get_field('nettside'); endif;
                    if(get_field('selskap_logo')):
                        $logo_url = get_field('selskap_logo')['url'];
                    else :  
                        $logo_url = get_stylesheet_directory_uri().'/images/placeholder.jpg';
                    endif;
                        
                    ?>
                        <a <?php if(get_field('nettside')): ?> target="_target" <?php endif; ?> href="<?php echo $permalink; ?>"><div class="slide" style="background-image:url('<?php echo $logo_url; ?>')"></div></a>
                    <?php
                    
                endwhile;
                wp_reset_postdata();
            endif;
        ?>
    </div>

    <script>
        jQuery('.slider').slick({
        dots: false,
        infinite: true,
        speed: 2000,
        slidesToShow: 6,
        slidesToScroll: 6,
        //touchThreshold: 6,
        //autoplay: true,
        //autoplaySpeed: 5000,
        responsive: [
            
            {
            breakpoint: 1024,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3,
                    swipeToSlide: true,
                }
            },

            {
            breakpoint: 769,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2,
                }
            }

        ]
        });
    </script>

</div>
