<?php
/**
 * Order details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates/Emails
 * @version 3.7.0
 */

defined( 'ABSPATH' ) || exit;

$text_align = is_rtl() ? 'right' : 'left';

//do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<h2 style="display:none !important">
	<?php
	if ( $sent_to_admin ) {
		$before = '<a class="link"  href="' . esc_url( $order->get_edit_order_url() ) . '">';
		$after  = '</a>';
	} else {
		$before = '';
		$after  = '';
	}
	/* translators: %s: Order ID. */
	echo wp_kses_post( $before . sprintf( __( '[Order #%s]', 'woocommerce' ) . $after . ' (<time datetime="%s">%s</time>)', $order->get_order_number(), $order->get_date_created()->format( 'c' ), wc_format_datetime( $order->get_date_created() ) ) );
	?>
</h2>

<div>
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( '&nbsp;', 'woocommerce' ); ?></th><!--Productimage-->
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( '&nbsp;', 'woocommerce' ); ?></th><!--Name-->
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( '&nbsp;', 'woocommerce' ); ?></th><!--Quantity-->
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( '&nbsp;', 'woocommerce' ); ?></th><!--Price-->
			</tr>
		</thead>
		<tbody>
			<?php
			//order items:
		$items = $order->get_items();
		foreach ($items as $item_id => $item) {
			$_product = apply_filters('woocommerce_order_item_product', $order->get_product_from_item($item), $item);
			/* $item_meta = new WC_Order_Item_Meta($item, $_product);*/
			$show_download_links = ''; // initialized as not set
			$purchase_note = get_post_meta($_product->get_id(), '_purchase_note', true);

			if (apply_filters('woocommerce_order_item_visible', true, $item)) {
				?>
				<tr style="border-bottom: 1px solid 1px solid rgba(78, 78, 78, 0.1);" class="<?php echo esc_attr(apply_filters('woocommerce_order_item_class', 'order_item', $item, $order)); ?>">
					<td class="td single_prod" style="width: 18%;text-align:left; vertical-align:middle; font-family: 'PT Sans', sans-serif;border-bottom: 1px solid rgba(78, 78, 78, 0.1);padding: 12px; padding-left: 0;color: #737373;">

						<?php
						echo apply_filters('woocommerce_order_item_thumbnail', '<div style="margin-bottom: 5px"><img src="' . ( $_product->get_image_id() ? current(wp_get_attachment_image_src($_product->get_image_id(), 'full')) : wc_placeholder_img_src() ) . '" alt="' . esc_attr__('Product Image', 'woocommerce') . '" height="auto" width="80px" style="vertical-align:middle; margin-right: 10px;" /></div>', $item);
						?>
					</td>
					<td class="td single_prod" style="text-align:left; vertical-align:middle; font-family: 'PT Sans', sans-serif; word-wrap:break-word;border-bottom: 1px solid rgba(78, 78, 78, 0.1);padding: 12px;color: #737373;"><?php
						// Product name
						echo apply_filters('woocommerce_order_item_name', $item['name'], $item, false);

						// allow other plugins to add additional product information here
						do_action('woocommerce_order_item_meta_start', $item_id, $item, $order);

						// Variation
						if (!empty($item_meta->meta)) {
							echo '<br/><small>' . nl2br($item_meta->display(true, true, '_', "\n")) . '</small>';
						}

						// File URLs
						if ($show_download_links) {
							$order->display_item_downloads($item);
						}

						// allow other plugins to add additional product information here
						do_action('woocommerce_order_item_meta_end', $item_id, $item, $order);

						$kategoribeskrivelse = get_field('kategoribeskrivelse' , $_product->get_id());
						if ($kategoribeskrivelse) {
							echo '<p class="custom_text">'.$kategoribeskrivelse.'</p>';
						}
						?>

					</td>
					<td class="td single_prod" style="text-align:center; vertical-align:middle; font-family: 'PT Sans', sans-serif;border-bottom: 1px solid rgba(78, 78, 78, 0.1);padding: 12px 5px;color: #737373;width:20%;">
						<?php _e('Antall:', 'sefbo'); ?> <?php echo apply_filters('woocommerce_email_order_item_quantity', $item['qty'], $item); ?>
					</td>

					<td class="td single_prod" style="text-align:right; vertical-align:middle; font-family: 'PT Sans', sans-serif;border-bottom: 1px solid rgba(78, 78, 78, 0.1);padding: 12px;color: #737373;width:20%;">
						<?php echo $order->get_formatted_line_subtotal($item); ?>
					</td>
				</tr>
				<?php
			}
		}
		//Order items ends
		?>
		</tbody>
		</tfoot>
	</table>
</div>
		
	
		<div style="padding:5px 15px;text-align:right; font-size: 16px; padding-left: 0;border-bottom: 1px solid rgba(78, 78, 78, 0.1);padding-right: 12px;">
			<ul style="list-style-type:none;padding-left:0;margin-bottom:7px;margin-top: 21px;">
				<li style="margin-left: 0; text-align: right;">
					<span style="display: inline-block;"><?php _e('Frakt:', 'sefbo'); ?> </span>
					<?php
						$shipping_tax = 0;
						$order_shipping_total = $order->get_total_shipping();
						$shipping_tax = $order->get_shipping_tax();
						if(!$shipping_tax){
							$shipping_tax = 0;
						}
						$order_shipping_total = $order_shipping_total + $shipping_tax;
					?>
					<span style="display: inline-block; width: 30%;"><?php echo wc_price($order_shipping_total, array('currency' => $order->get_currency())); ?></span>
				</li>
				<?php

				if ($order->get_total_discount() > 0) { ?>
					<li style="margin-left: 0; text-align: right;">
						<span style="display: inline-block;"><?php _e('Rabatt:', 'sefbo'); ?> </span>
						<span style="display: inline-block; width: 30%;"> - <?php echo wc_price(($order->get_total_discount('edit') + $order->get_discount_tax('edit')), array('currency' => $order->get_currency())); ?></span>
					</li>
					<?php
				}
				?>
				<li style="margin-left: 0; text-align: right;">
					<span style="display: inline-block;"><strong><?php _e('Totalt:', 'sefbo'); ?></strong></span>
					<span style="display: inline-block; width: 30%;"><strong><?php echo $order->get_formatted_order_total(false); ?> </strong></span>
				</li>
				<?php
					$amount = '';
					$taxrate_html = '';
					foreach ( $order->get_tax_totals() as $code => $tax ) :
						$tax_rates = WC_Tax::get_rates();
							if(!empty($tax_rates)){
							$taxrate=$tax_rates[$tax->rate_id]['rate'];
							$taxrate=number_format((float)$taxrate, 0, '.', '');
							$taxrate.='%';
						}
						$amount = $tax->amount;
					endforeach;

					if($amount){
						if($taxrate){
							$taxrate_html = "(".$taxrate.")";
						} else {
							$taxrate_html = '';
						}
				?>
					<li style="margin-left: 0; text-align: right;">
						<span style="display: inline-block;font-style: italic;font-size:12px;">
						<?php _e('MVA ','sefbo');?><?php echo $taxrate_html .''; ?> </span>:
						<span style="display: inline-block; width: 30%;font-style: italic;font-size:12px;"> <?php echo wc_price($amount, array('currency' => $order->get_currency())); ?></span>
					</li>
				<?php } ?>
			</ul>
		</div>
		
		<div class="orderdetails-wrapper">
			<table class="orderdetails" style="font-size: 16px; width:100%;vertical-align:top;">
				<tr>
					<td class="header"><?php _e('Ordrenr', 'sefbo'); ?></td>
					<td><?php echo $order->get_order_number(); ?></td>
				</tr>

				<tr>
					<td class="header"><?php _e('Betaling', 'sefbo'); ?></td>
					<td><?php echo $order->get_payment_method_title(); ?></td>
				</tr>

				<tr>
					<td class="header"><?php _e('Levering', 'sefbo'); ?></td>
					<td><?php echo $order->get_shipping_method(); ?></td>
				</tr>

				<tr>
					<td class="header"><?php _e('Ordredato', 'sefbo'); ?></td>
					<td><?php echo date('d.m.Y', strtotime($order->get_date_created('edit'))); ?></td>
				</tr>

			</table>
		</div>
		<div class="deliveryinfo-wrapper">
		
			<table class="deliveryinfo" cellspacing="0" cellpadding="0" style="width:50%;vertical-align:top;float:left;" border="0">
				<tbody>
					<tr>
						<?php if (( $billing = $order->get_formatted_billing_address())) : ?>
							<td class="td" style="text-align:left; font-family: 'PT Sans', sans-serif;" valign="top" width="100%">
								<p class="text"><strong style="display: inline-block; margin-bottom: 6px;"><?php _e('Fakturaadresse', 'sefbo'); ?></strong><br/><?php echo $billing; ?></p>
							</td>
						<?php endif; ?>
					</tr>
				</tbody>
			</table>
			
			<table class="deliveryinfo" cellspacing="0" cellpadding="0" style="width:50%;vertical-align:top;" border="0">
				<tbody>
					<tr>
						<?php if ($order->needs_shipping_address() && ( $shipping = $order->get_formatted_shipping_address() )) : ?>
							<td class="td" style="text-align:left;" valign="top" width="100%">
								<p class="text"><strong style="display: inline-block; margin-bottom: 6px;"><?php _e('Leveringsadresse', 'sefbo'); ?></strong><br/><?php echo $shipping; ?></p>
							</td>
						<?php endif; ?>
					</tr>
				</tbody>
			</table>

		</div>
			
	

